/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import nxt.Attachment;
import nxt.Db;
import nxt.Nxt;
import nxt.Transaction;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.EntityDbTable;
import nxt.util.Listener;
import nxt.util.Listeners;

public final class CurrencyTransfer {
    private static final Listeners<CurrencyTransfer, Event> listeners = new Listeners();
    private static final DbKey.LongKeyFactory<CurrencyTransfer> currencyTransferDbKeyFactory = new DbKey.LongKeyFactory<CurrencyTransfer>("id"){

        @Override
        public DbKey newKey(CurrencyTransfer currencyTransfer) {
            return currencyTransfer.dbKey;
        }
    };
    private static final EntityDbTable<CurrencyTransfer> currencyTransferTable = new EntityDbTable<CurrencyTransfer>("currency_transfer", currencyTransferDbKeyFactory){

        @Override
        protected CurrencyTransfer load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new CurrencyTransfer(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, CurrencyTransfer currencyTransfer) throws SQLException {
            currencyTransfer.save(connection);
        }
    };
    private final long id;
    private final DbKey dbKey;
    private final long currencyId;
    private final int height;
    private final long senderId;
    private final long recipientId;
    private final long units;
    private final int timestamp;

    public static DbIterator<CurrencyTransfer> getAllTransfers(int n, int n2) {
        return currencyTransferTable.getAll(n, n2);
    }

    public static int getCount() {
        return currencyTransferTable.getCount();
    }

    public static boolean addListener(Listener<CurrencyTransfer> listener, Event event) {
        return listeners.addListener(listener, event);
    }

    public static boolean removeListener(Listener<CurrencyTransfer> listener, Event event) {
        return listeners.removeListener(listener, event);
    }

    public static DbIterator<CurrencyTransfer> getCurrencyTransfers(long l, int n, int n2) {
        return currencyTransferTable.getManyBy(new DbClause.LongClause("currency_id", l), n, n2);
    }

    public static DbIterator<CurrencyTransfer> getAccountCurrencyTransfers(long l, int n, int n2) {
        Connection connection = null;
        try {
            connection = Db.db.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM currency_transfer WHERE sender_id = ? UNION ALL SELECT * FROM currency_transfer WHERE recipient_id = ? AND sender_id <> ? ORDER BY height DESC, db_id DESC" + DbUtils.limitsClause(n, n2));
            int n3 = 0;
            preparedStatement.setLong(++n3, l);
            preparedStatement.setLong(++n3, l);
            preparedStatement.setLong(++n3, l);
            DbUtils.setLimits(++n3, preparedStatement, n, n2);
            return currencyTransferTable.getManyBy(connection, preparedStatement, false);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public static DbIterator<CurrencyTransfer> getAccountCurrencyTransfers(long l, long l2, int n, int n2) {
        Connection connection = null;
        try {
            connection = Db.db.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM currency_transfer WHERE sender_id = ? AND currency_id = ? UNION ALL SELECT * FROM currency_transfer WHERE recipient_id = ? AND sender_id <> ? AND currency_id = ? ORDER BY height DESC, db_id DESC" + DbUtils.limitsClause(n, n2));
            int n3 = 0;
            preparedStatement.setLong(++n3, l);
            preparedStatement.setLong(++n3, l2);
            preparedStatement.setLong(++n3, l);
            preparedStatement.setLong(++n3, l);
            preparedStatement.setLong(++n3, l2);
            DbUtils.setLimits(++n3, preparedStatement, n, n2);
            return currencyTransferTable.getManyBy(connection, preparedStatement, false);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public static int getTransferCount(long l) {
        return currencyTransferTable.getCount(new DbClause.LongClause("currency_id", l));
    }

    static CurrencyTransfer addTransfer(Transaction transaction, Attachment.MonetarySystemCurrencyTransfer monetarySystemCurrencyTransfer) {
        CurrencyTransfer currencyTransfer = new CurrencyTransfer(transaction, monetarySystemCurrencyTransfer);
        currencyTransferTable.insert(currencyTransfer);
        listeners.notify(currencyTransfer, Event.TRANSFER);
        return currencyTransfer;
    }

    static void init() {
    }

    private CurrencyTransfer(Transaction transaction, Attachment.MonetarySystemCurrencyTransfer monetarySystemCurrencyTransfer) {
        this.id = transaction.getId();
        this.dbKey = currencyTransferDbKeyFactory.newKey(this.id);
        this.height = Nxt.getBlockchain().getHeight();
        this.currencyId = monetarySystemCurrencyTransfer.getCurrencyId();
        this.senderId = transaction.getSenderId();
        this.recipientId = transaction.getRecipientId();
        this.units = monetarySystemCurrencyTransfer.getUnits();
        this.timestamp = Nxt.getBlockchain().getLastBlockTimestamp();
    }

    private CurrencyTransfer(ResultSet resultSet, DbKey dbKey) throws SQLException {
        this.id = resultSet.getLong("id");
        this.dbKey = dbKey;
        this.currencyId = resultSet.getLong("currency_id");
        this.senderId = resultSet.getLong("sender_id");
        this.recipientId = resultSet.getLong("recipient_id");
        this.units = resultSet.getLong("units");
        this.timestamp = resultSet.getInt("timestamp");
        this.height = resultSet.getInt("height");
    }

    private void save(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO currency_transfer (id, currency_id, sender_id, recipient_id, units, timestamp, height) VALUES (?, ?, ?, ?, ?, ?, ?)");){
            int n = 0;
            preparedStatement.setLong(++n, this.id);
            preparedStatement.setLong(++n, this.currencyId);
            preparedStatement.setLong(++n, this.senderId);
            preparedStatement.setLong(++n, this.recipientId);
            preparedStatement.setLong(++n, this.units);
            preparedStatement.setInt(++n, this.timestamp);
            preparedStatement.setInt(++n, this.height);
            preparedStatement.executeUpdate();
        }
    }

    public long getId() {
        return this.id;
    }

    public long getCurrencyId() {
        return this.currencyId;
    }

    public long getSenderId() {
        return this.senderId;
    }

    public long getRecipientId() {
        return this.recipientId;
    }

    public long getUnits() {
        return this.units;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public int getHeight() {
        return this.height;
    }

    public static enum Event {
        TRANSFER;

    }
}

