/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import nxt.Account;
import nxt.AccountLedger;

public enum HoldingType {
    NXT(0){

        @Override
        public long getBalance(Account account, long l) {
            if (l != 0L) {
                throw new IllegalArgumentException("holdingId must be 0");
            }
            return account.getBalanceNQT();
        }

        @Override
        public long getUnconfirmedBalance(Account account, long l) {
            if (l != 0L) {
                throw new IllegalArgumentException("holdingId must be 0");
            }
            return account.getUnconfirmedBalanceNQT();
        }

        @Override
        void addToBalance(Account account, AccountLedger.LedgerEvent ledgerEvent, long l, long l2, long l3) {
            if (l2 != 0L) {
                throw new IllegalArgumentException("holdingId must be 0");
            }
            account.addToBalanceNQT(ledgerEvent, l, l3);
        }

        @Override
        void addToUnconfirmedBalance(Account account, AccountLedger.LedgerEvent ledgerEvent, long l, long l2, long l3) {
            if (l2 != 0L) {
                throw new IllegalArgumentException("holdingId must be 0");
            }
            account.addToUnconfirmedBalanceNQT(ledgerEvent, l, l3);
        }

        @Override
        void addToBalanceAndUnconfirmedBalance(Account account, AccountLedger.LedgerEvent ledgerEvent, long l, long l2, long l3) {
            if (l2 != 0L) {
                throw new IllegalArgumentException("holdingId must be 0");
            }
            account.addToBalanceAndUnconfirmedBalanceNQT(ledgerEvent, l, l3);
        }
    }
    ,
    ASSET(1){

        @Override
        public long getBalance(Account account, long l) {
            return account.getAssetBalanceQNT(l);
        }

        @Override
        public long getUnconfirmedBalance(Account account, long l) {
            return account.getUnconfirmedAssetBalanceQNT(l);
        }

        @Override
        void addToBalance(Account account, AccountLedger.LedgerEvent ledgerEvent, long l, long l2, long l3) {
            account.addToAssetBalanceQNT(ledgerEvent, l, l2, l3);
        }

        @Override
        void addToUnconfirmedBalance(Account account, AccountLedger.LedgerEvent ledgerEvent, long l, long l2, long l3) {
            account.addToUnconfirmedAssetBalanceQNT(ledgerEvent, l, l2, l3);
        }

        @Override
        void addToBalanceAndUnconfirmedBalance(Account account, AccountLedger.LedgerEvent ledgerEvent, long l, long l2, long l3) {
            account.addToAssetAndUnconfirmedAssetBalanceQNT(ledgerEvent, l, l2, l3);
        }
    }
    ,
    CURRENCY(2){

        @Override
        public long getBalance(Account account, long l) {
            return account.getCurrencyUnits(l);
        }

        @Override
        public long getUnconfirmedBalance(Account account, long l) {
            return account.getUnconfirmedCurrencyUnits(l);
        }

        @Override
        void addToBalance(Account account, AccountLedger.LedgerEvent ledgerEvent, long l, long l2, long l3) {
            account.addToCurrencyUnits(ledgerEvent, l, l2, l3);
        }

        @Override
        void addToUnconfirmedBalance(Account account, AccountLedger.LedgerEvent ledgerEvent, long l, long l2, long l3) {
            account.addToUnconfirmedCurrencyUnits(ledgerEvent, l, l2, l3);
        }

        @Override
        void addToBalanceAndUnconfirmedBalance(Account account, AccountLedger.LedgerEvent ledgerEvent, long l, long l2, long l3) {
            account.addToCurrencyAndUnconfirmedCurrencyUnits(ledgerEvent, l, l2, l3);
        }
    };

    private final byte code;

    public static HoldingType get(byte by) {
        for (HoldingType holdingType : HoldingType.values()) {
            if (holdingType.getCode() != by) continue;
            return holdingType;
        }
        throw new IllegalArgumentException("Invalid holdingType code: " + by);
    }

    private HoldingType(byte by) {
        this.code = by;
    }

    public byte getCode() {
        return this.code;
    }

    public abstract long getBalance(Account var1, long var2);

    public abstract long getUnconfirmedBalance(Account var1, long var2);

    abstract void addToBalance(Account var1, AccountLedger.LedgerEvent var2, long var3, long var5, long var7);

    abstract void addToUnconfirmedBalance(Account var1, AccountLedger.LedgerEvent var2, long var3, long var5, long var7);

    abstract void addToBalanceAndUnconfirmedBalance(Account var1, AccountLedger.LedgerEvent var2, long var3, long var5, long var7);
}

