/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nxt.Attachment;
import nxt.Constants;
import nxt.Db;
import nxt.Nxt;
import nxt.Transaction;
import nxt.TransactionDb;
import nxt.TransactionImpl;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.VersionedEntityDbTable;
import nxt.db.VersionedPersistentDbTable;
import nxt.db.VersionedPrunableDbTable;
import nxt.db.VersionedValuesDbTable;
import nxt.util.Logger;
import nxt.util.Search;

public class TaggedData {
    private static final DbKey.LongKeyFactory<TaggedData> taggedDataKeyFactory = new DbKey.LongKeyFactory<TaggedData>("id"){

        @Override
        public DbKey newKey(TaggedData taggedData) {
            return taggedData.dbKey;
        }
    };
    private static final VersionedPrunableDbTable<TaggedData> taggedDataTable = new VersionedPrunableDbTable<TaggedData>("tagged_data", taggedDataKeyFactory, "name,description,tags"){

        @Override
        protected TaggedData load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new TaggedData(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, TaggedData taggedData) throws SQLException {
            taggedData.save(connection);
        }

        @Override
        protected String defaultSort() {
            return " ORDER BY block_timestamp DESC, height DESC, db_id DESC ";
        }

        @Override
        protected void prune() {
            if (Constants.ENABLE_PRUNING) {
                try (Connection connection = db.getConnection();
                     PreparedStatement preparedStatement = connection.prepareStatement("SELECT parsed_tags FROM tagged_data WHERE transaction_timestamp < ? AND latest = TRUE ");){
                    int n = Nxt.getEpochTime() - Constants.MAX_PRUNABLE_LIFETIME;
                    preparedStatement.setInt(1, n);
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        while (resultSet.next()) {
                            Object[] objectArray;
                            for (Object object : objectArray = (Object[])resultSet.getArray("parsed_tags").getArray()) {
                                Integer n2 = (Integer)hashMap.get(object);
                                hashMap.put((String)object, n2 != null ? n2 + 1 : 1);
                            }
                        }
                    }
                    Tag.delete(hashMap);
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException.toString(), sQLException);
                }
            }
            super.prune();
        }
    };
    private static final DbKey.LongKeyFactory<Timestamp> timestampKeyFactory = new DbKey.LongKeyFactory<Timestamp>("id"){

        @Override
        public DbKey newKey(Timestamp timestamp) {
            return timestamp.dbKey;
        }
    };
    private static final VersionedEntityDbTable<Timestamp> timestampTable = new VersionedEntityDbTable<Timestamp>("tagged_data_timestamp", timestampKeyFactory){

        @Override
        protected Timestamp load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new Timestamp(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, Timestamp timestamp) throws SQLException {
            timestamp.save(connection);
        }
    };
    private static final DbKey.LongKeyFactory<Long> extendDbKeyFactory = new DbKey.LongKeyFactory<Long>("id"){

        @Override
        public DbKey newKey(Long l) {
            return this.newKey((long)l);
        }
    };
    private static final VersionedValuesDbTable<Long, Long> extendTable = new VersionedValuesDbTable<Long, Long>("tagged_data_extend", extendDbKeyFactory){

        @Override
        protected Long load(Connection connection, ResultSet resultSet) throws SQLException {
            return resultSet.getLong("extend_id");
        }

        @Override
        protected void save(Connection connection, Long l, Long l2) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO tagged_data_extend (id, extend_id, height, latest) VALUES (?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, l);
                preparedStatement.setLong(++n, l2);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }
    };
    private final long id;
    private final DbKey dbKey;
    private final long accountId;
    private final String name;
    private final String description;
    private final String tags;
    private final String[] parsedTags;
    private final byte[] data;
    private final String type;
    private final String channel;
    private final boolean isText;
    private final String filename;
    private int transactionTimestamp;
    private int blockTimestamp;
    private int height;

    public static int getCount() {
        return taggedDataTable.getCount();
    }

    public static DbIterator<TaggedData> getAll(int n, int n2) {
        return taggedDataTable.getAll(n, n2);
    }

    public static TaggedData getData(long l) {
        return (TaggedData)taggedDataTable.get(taggedDataKeyFactory.newKey(l));
    }

    public static List<Long> getExtendTransactionIds(long l) {
        return extendTable.get(extendDbKeyFactory.newKey(l));
    }

    public static DbIterator<TaggedData> getData(String string, long l, int n, int n2) {
        if (string == null && l == 0L) {
            throw new IllegalArgumentException("Either channel, or accountId, or both, must be specified");
        }
        return taggedDataTable.getManyBy(TaggedData.getDbClause(string, l), n, n2);
    }

    public static DbIterator<TaggedData> searchData(String string, String string2, long l, int n, int n2) {
        return taggedDataTable.search(string, TaggedData.getDbClause(string2, l), n, n2, " ORDER BY ft.score DESC, tagged_data.block_timestamp DESC, tagged_data.db_id DESC ");
    }

    private static DbClause getDbClause(String string, long l) {
        DbClause dbClause = DbClause.EMPTY_CLAUSE;
        if (string != null) {
            dbClause = new DbClause.StringClause("channel", string);
        }
        if (l != 0L) {
            DbClause.LongClause longClause = new DbClause.LongClause("account_id", l);
            dbClause = dbClause != DbClause.EMPTY_CLAUSE ? dbClause.and(longClause) : longClause;
        }
        return dbClause;
    }

    static void init() {
        Tag.init();
    }

    public TaggedData(Transaction transaction, Attachment.TaggedDataAttachment taggedDataAttachment) {
        this(transaction, taggedDataAttachment, Nxt.getBlockchain().getLastBlockTimestamp(), Nxt.getBlockchain().getHeight());
    }

    private TaggedData(Transaction transaction, Attachment.TaggedDataAttachment taggedDataAttachment, int n, int n2) {
        this.id = transaction.getId();
        this.dbKey = taggedDataKeyFactory.newKey(this.id);
        this.accountId = transaction.getSenderId();
        this.name = taggedDataAttachment.getName();
        this.description = taggedDataAttachment.getDescription();
        this.tags = taggedDataAttachment.getTags();
        this.parsedTags = Search.parseTags(this.tags, 3, 20, 5);
        this.data = taggedDataAttachment.getData();
        this.type = taggedDataAttachment.getType();
        this.channel = taggedDataAttachment.getChannel();
        this.isText = taggedDataAttachment.isText();
        this.filename = taggedDataAttachment.getFilename();
        this.blockTimestamp = n;
        this.transactionTimestamp = transaction.getTimestamp();
        this.height = n2;
    }

    private TaggedData(ResultSet resultSet, DbKey dbKey) throws SQLException {
        this.id = resultSet.getLong("id");
        this.dbKey = dbKey;
        this.accountId = resultSet.getLong("account_id");
        this.name = resultSet.getString("name");
        this.description = resultSet.getString("description");
        this.tags = resultSet.getString("tags");
        this.parsedTags = (String[])DbUtils.getArray(resultSet, "parsed_tags", String[].class);
        this.data = resultSet.getBytes("data");
        this.type = resultSet.getString("type");
        this.channel = resultSet.getString("channel");
        this.isText = resultSet.getBoolean("is_text");
        this.filename = resultSet.getString("filename");
        this.blockTimestamp = resultSet.getInt("block_timestamp");
        this.transactionTimestamp = resultSet.getInt("transaction_timestamp");
        this.height = resultSet.getInt("height");
    }

    private void save(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO tagged_data (id, account_id, name, description, tags, parsed_tags, type, channel, data, is_text, filename, block_timestamp, transaction_timestamp, height, latest) KEY (id, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, TRUE)");){
            int n = 0;
            preparedStatement.setLong(++n, this.id);
            preparedStatement.setLong(++n, this.accountId);
            preparedStatement.setString(++n, this.name);
            preparedStatement.setString(++n, this.description);
            preparedStatement.setString(++n, this.tags);
            DbUtils.setArray(preparedStatement, ++n, this.parsedTags);
            preparedStatement.setString(++n, this.type);
            preparedStatement.setString(++n, this.channel);
            preparedStatement.setBytes(++n, this.data);
            preparedStatement.setBoolean(++n, this.isText);
            preparedStatement.setString(++n, this.filename);
            preparedStatement.setInt(++n, this.blockTimestamp);
            preparedStatement.setInt(++n, this.transactionTimestamp);
            preparedStatement.setInt(++n, this.height);
            preparedStatement.executeUpdate();
        }
    }

    public long getId() {
        return this.id;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTags() {
        return this.tags;
    }

    public String[] getParsedTags() {
        return this.parsedTags;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getType() {
        return this.type;
    }

    public String getChannel() {
        return this.channel;
    }

    public boolean isText() {
        return this.isText;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getTransactionTimestamp() {
        return this.transactionTimestamp;
    }

    public int getBlockTimestamp() {
        return this.blockTimestamp;
    }

    static void add(TransactionImpl transactionImpl, Attachment.TaggedDataUpload taggedDataUpload) {
        Object object;
        if (Nxt.getEpochTime() - transactionImpl.getTimestamp() < Constants.MAX_PRUNABLE_LIFETIME && taggedDataUpload.getData() != null && (object = (TaggedData)taggedDataTable.get(transactionImpl.getDbKey())) == null) {
            object = new TaggedData(transactionImpl, taggedDataUpload);
            taggedDataTable.insert((TaggedData)object);
            Tag.add((TaggedData)object);
        }
        object = new Timestamp(transactionImpl.getId(), transactionImpl.getTimestamp());
        timestampTable.insert((Timestamp)object);
    }

    static void extend(Transaction transaction, Attachment.TaggedDataExtend taggedDataExtend) {
        long l = taggedDataExtend.getTaggedDataId();
        DbKey dbKey = taggedDataKeyFactory.newKey(l);
        Timestamp timestamp = (Timestamp)timestampTable.get(dbKey);
        if (transaction.getTimestamp() - Constants.MIN_PRUNABLE_LIFETIME > timestamp.timestamp) {
            timestamp.timestamp = transaction.getTimestamp();
        } else {
            timestamp.timestamp = timestamp.timestamp + Math.min(Constants.MIN_PRUNABLE_LIFETIME, Integer.MAX_VALUE - timestamp.timestamp);
        }
        timestampTable.insert(timestamp);
        List list = extendTable.get(dbKey);
        list.add(transaction.getId());
        extendTable.insert(l, list);
        if (Nxt.getEpochTime() - Constants.MAX_PRUNABLE_LIFETIME < timestamp.timestamp) {
            TaggedData taggedData = (TaggedData)taggedDataTable.get(dbKey);
            if (taggedData == null && taggedDataExtend.getData() != null) {
                TransactionImpl transactionImpl = TransactionDb.findTransaction(l);
                taggedData = new TaggedData(transactionImpl, taggedDataExtend);
                Tag.add(taggedData);
            }
            if (taggedData != null) {
                taggedData.transactionTimestamp = timestamp.timestamp;
                taggedData.blockTimestamp = Nxt.getBlockchain().getLastBlockTimestamp();
                taggedData.height = Nxt.getBlockchain().getHeight();
                taggedDataTable.insert(taggedData);
            }
        }
    }

    static void restore(Transaction transaction, Attachment.TaggedDataUpload taggedDataUpload, int n, int n2) {
        TaggedData taggedData = new TaggedData(transaction, taggedDataUpload, n, n2);
        taggedDataTable.insert(taggedData);
        Tag.add(taggedData, n2);
        int n3 = transaction.getTimestamp();
        for (long l : TaggedData.getExtendTransactionIds(transaction.getId())) {
            TransactionImpl transactionImpl = TransactionDb.findTransaction(l);
            n3 = transactionImpl.getTimestamp() - Constants.MIN_PRUNABLE_LIFETIME > n3 ? transactionImpl.getTimestamp() : (n3 += Math.min(Constants.MIN_PRUNABLE_LIFETIME, Integer.MAX_VALUE - n3));
            taggedData.transactionTimestamp = n3;
            taggedData.blockTimestamp = transactionImpl.getBlockTimestamp();
            taggedData.height = transactionImpl.getHeight();
            taggedDataTable.insert(taggedData);
        }
    }

    /*
     * Exception decompiling
     */
    static boolean isPruned(long var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final class Tag {
        private static final DbKey.StringKeyFactory<Tag> tagDbKeyFactory = new DbKey.StringKeyFactory<Tag>("tag"){

            @Override
            public DbKey newKey(Tag tag) {
                return tag.dbKey;
            }
        };
        private static final VersionedPersistentDbTable<Tag> tagTable = new VersionedPersistentDbTable<Tag>("data_tag", tagDbKeyFactory){

            @Override
            protected Tag load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new Tag(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, Tag tag) throws SQLException {
                tag.save(connection);
            }

            @Override
            public String defaultSort() {
                return " ORDER BY tag_count DESC, tag ASC ";
            }
        };
        private final String tag;
        private final DbKey dbKey;
        private final int height;
        private int count;

        public static int getTagCount() {
            return tagTable.getCount();
        }

        public static DbIterator<Tag> getAllTags(int n, int n2) {
            return tagTable.getAll(n, n2);
        }

        public static DbIterator<Tag> getTagsLike(String string, int n, int n2) {
            DbClause.LikeClause likeClause = new DbClause.LikeClause("tag", string);
            return tagTable.getManyBy((DbClause)likeClause, n, n2, " ORDER BY tag ");
        }

        private static void init() {
        }

        private static void add(TaggedData taggedData) {
            for (String string : taggedData.getParsedTags()) {
                Tag tag = (Tag)tagTable.get(tagDbKeyFactory.newKey(string));
                if (tag == null) {
                    tag = new Tag(string, Nxt.getBlockchain().getHeight());
                }
                ++tag.count;
                tagTable.insert(tag);
            }
        }

        private static void add(TaggedData taggedData, int n) {
            try (Connection connection = Db.db.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement("UPDATE data_tag SET tag_count = tag_count + 1 WHERE tag = ? AND height >= ?");){
                for (String string : taggedData.getParsedTags()) {
                    preparedStatement.setString(1, string);
                    preparedStatement.setInt(2, n);
                    int n2 = preparedStatement.executeUpdate();
                    if (n2 != 0) continue;
                    Tag tag = new Tag(string, n);
                    ++tag.count;
                    tagTable.insert(tag);
                }
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException.toString(), sQLException);
            }
        }

        private static void delete(Map<String, Integer> map) {
            try (Connection connection = Db.db.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement("UPDATE data_tag SET tag_count = tag_count - ? WHERE tag = ?");
                 PreparedStatement preparedStatement2 = connection.prepareStatement("DELETE FROM data_tag WHERE tag_count <= 0 LIMIT " + Constants.BATCH_COMMIT_SIZE);){
                int n;
                for (Map.Entry<String, Integer> entry : map.entrySet()) {
                    preparedStatement.setInt(1, entry.getValue());
                    preparedStatement.setString(2, entry.getKey());
                    preparedStatement.executeUpdate();
                    Logger.logDebugMessage("Reduced tag count for " + entry.getKey() + " by " + entry.getValue());
                }
                do {
                    if ((n = preparedStatement2.executeUpdate()) > 0) {
                        Logger.logDebugMessage("Deleted " + n + " tags");
                    }
                    Db.db.commitTransaction();
                } while (n >= Constants.BATCH_COMMIT_SIZE);
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException.toString(), sQLException);
            }
        }

        private Tag(String string, int n) {
            this.tag = string;
            this.dbKey = tagDbKeyFactory.newKey(this.tag);
            this.height = n;
        }

        private Tag(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.tag = resultSet.getString("tag");
            this.dbKey = dbKey;
            this.count = resultSet.getInt("tag_count");
            this.height = resultSet.getInt("height");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO data_tag (tag, tag_count, height, latest) KEY (tag, height) VALUES (?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setString(++n, this.tag);
                preparedStatement.setInt(++n, this.count);
                preparedStatement.setInt(++n, this.height);
                preparedStatement.executeUpdate();
            }
        }

        public String getTag() {
            return this.tag;
        }

        public int getCount() {
            return this.count;
        }
    }

    private static final class Timestamp {
        private final long id;
        private final DbKey dbKey;
        private int timestamp;

        private Timestamp(long l, int n) {
            this.id = l;
            this.dbKey = timestampKeyFactory.newKey(this.id);
            this.timestamp = n;
        }

        private Timestamp(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.id = resultSet.getLong("id");
            this.dbKey = dbKey;
            this.timestamp = resultSet.getInt("timestamp");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO tagged_data_timestamp (id, timestamp, height, latest) KEY (id, height) VALUES (?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.id);
                preparedStatement.setInt(++n, this.timestamp);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }
    }
}

