/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import nxt.Block;
import nxt.Constants;
import nxt.Db;
import nxt.Nxt;
import nxt.Order;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.EntityDbTable;
import nxt.util.Listener;
import nxt.util.Listeners;

public final class Trade {
    private static final Listeners<Trade, Event> listeners = new Listeners();
    private static final DbKey.LinkKeyFactory<Trade> tradeDbKeyFactory = new DbKey.LinkKeyFactory<Trade>("ask_order_id", "bid_order_id"){

        @Override
        public DbKey newKey(Trade trade) {
            return trade.dbKey;
        }
    };
    private static final EntityDbTable<Trade> tradeTable = new EntityDbTable<Trade>("trade", tradeDbKeyFactory){

        @Override
        protected Trade load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new Trade(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, Trade trade) throws SQLException {
            trade.save(connection);
        }
    };
    private final int timestamp;
    private final long assetId;
    private final long blockId;
    private final int height;
    private final long askOrderId;
    private final long bidOrderId;
    private final int askOrderHeight;
    private final int bidOrderHeight;
    private final long sellerId;
    private final long buyerId;
    private final DbKey dbKey;
    private final long quantityQNT;
    private final long priceNQT;
    private final boolean isBuy;

    public static DbIterator<Trade> getAllTrades(int n, int n2) {
        return tradeTable.getAll(n, n2);
    }

    public static int getCount() {
        return tradeTable.getCount();
    }

    public static boolean addListener(Listener<Trade> listener, Event event) {
        return listeners.addListener(listener, event);
    }

    public static boolean removeListener(Listener<Trade> listener, Event event) {
        return listeners.removeListener(listener, event);
    }

    public static Trade getTrade(long l, long l2) {
        return tradeTable.get(tradeDbKeyFactory.newKey(l, l2));
    }

    public static DbIterator<Trade> getAssetTrades(long l, int n, int n2) {
        return tradeTable.getManyBy(new DbClause.LongClause("asset_id", l), n, n2);
    }

    /*
     * Exception decompiling
     */
    public static List<Trade> getLastTrades(long[] var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static DbIterator<Trade> getAccountTrades(long l, int n, int n2) {
        Connection connection = null;
        try {
            connection = Db.db.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM trade WHERE seller_id = ? UNION ALL SELECT * FROM trade WHERE buyer_id = ? AND seller_id <> ? ORDER BY height DESC, db_id DESC" + DbUtils.limitsClause(n, n2));
            int n3 = 0;
            preparedStatement.setLong(++n3, l);
            preparedStatement.setLong(++n3, l);
            preparedStatement.setLong(++n3, l);
            DbUtils.setLimits(++n3, preparedStatement, n, n2);
            return tradeTable.getManyBy(connection, preparedStatement, false);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public static DbIterator<Trade> getAccountAssetTrades(long l, long l2, int n, int n2) {
        Connection connection = null;
        try {
            connection = Db.db.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM trade WHERE seller_id = ? AND asset_id = ? UNION ALL SELECT * FROM trade WHERE buyer_id = ? AND seller_id <> ? AND asset_id = ? ORDER BY height DESC, db_id DESC" + DbUtils.limitsClause(n, n2));
            int n3 = 0;
            preparedStatement.setLong(++n3, l);
            preparedStatement.setLong(++n3, l2);
            preparedStatement.setLong(++n3, l);
            preparedStatement.setLong(++n3, l);
            preparedStatement.setLong(++n3, l2);
            DbUtils.setLimits(++n3, preparedStatement, n, n2);
            return tradeTable.getManyBy(connection, preparedStatement, false);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public static DbIterator<Trade> getAskOrderTrades(long l, int n, int n2) {
        return tradeTable.getManyBy(new DbClause.LongClause("ask_order_id", l), n, n2);
    }

    public static DbIterator<Trade> getBidOrderTrades(long l, int n, int n2) {
        return tradeTable.getManyBy(new DbClause.LongClause("bid_order_id", l), n, n2);
    }

    public static int getTradeCount(long l) {
        return tradeTable.getCount(new DbClause.LongClause("asset_id", l));
    }

    static Trade addTrade(long l, Order.Ask ask, Order.Bid bid) {
        Trade trade = new Trade(l, ask, bid);
        tradeTable.insert(trade);
        listeners.notify(trade, Event.TRADE);
        return trade;
    }

    static void init() {
    }

    private Trade(long l, Order.Ask ask, Order.Bid bid) {
        Block block = Nxt.getBlockchain().getLastBlock();
        this.blockId = block.getId();
        this.height = block.getHeight();
        this.assetId = l;
        this.timestamp = block.getTimestamp();
        this.askOrderId = ask.getId();
        this.bidOrderId = bid.getId();
        this.askOrderHeight = ask.getHeight();
        this.bidOrderHeight = bid.getHeight();
        this.sellerId = ask.getAccountId();
        this.buyerId = bid.getAccountId();
        this.dbKey = tradeDbKeyFactory.newKey(this.askOrderId, this.bidOrderId);
        this.quantityQNT = Math.min(ask.getQuantityQNT(), bid.getQuantityQNT());
        this.isBuy = this.askOrderHeight < this.bidOrderHeight ? true : (this.askOrderHeight == this.bidOrderHeight ? (this.height <= Constants.PHASING_BLOCK ? this.askOrderId < this.bidOrderId : ask.getTransactionHeight() < bid.getTransactionHeight() || ask.getTransactionHeight() == bid.getTransactionHeight() && ask.getTransactionIndex() < bid.getTransactionIndex()) : false);
        this.priceNQT = this.isBuy ? ask.getPriceNQT() : bid.getPriceNQT();
    }

    private Trade(ResultSet resultSet, DbKey dbKey) throws SQLException {
        this.assetId = resultSet.getLong("asset_id");
        this.blockId = resultSet.getLong("block_id");
        this.askOrderId = resultSet.getLong("ask_order_id");
        this.bidOrderId = resultSet.getLong("bid_order_id");
        this.askOrderHeight = resultSet.getInt("ask_order_height");
        this.bidOrderHeight = resultSet.getInt("bid_order_height");
        this.sellerId = resultSet.getLong("seller_id");
        this.buyerId = resultSet.getLong("buyer_id");
        this.dbKey = dbKey;
        this.quantityQNT = resultSet.getLong("quantity");
        this.priceNQT = resultSet.getLong("price");
        this.timestamp = resultSet.getInt("timestamp");
        this.height = resultSet.getInt("height");
        this.isBuy = resultSet.getBoolean("is_buy");
    }

    private void save(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO trade (asset_id, block_id, ask_order_id, bid_order_id, ask_order_height, bid_order_height, seller_id, buyer_id, quantity, price, is_buy, timestamp, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
            int n = 0;
            preparedStatement.setLong(++n, this.assetId);
            preparedStatement.setLong(++n, this.blockId);
            preparedStatement.setLong(++n, this.askOrderId);
            preparedStatement.setLong(++n, this.bidOrderId);
            preparedStatement.setInt(++n, this.askOrderHeight);
            preparedStatement.setInt(++n, this.bidOrderHeight);
            preparedStatement.setLong(++n, this.sellerId);
            preparedStatement.setLong(++n, this.buyerId);
            preparedStatement.setLong(++n, this.quantityQNT);
            preparedStatement.setLong(++n, this.priceNQT);
            preparedStatement.setBoolean(++n, this.isBuy);
            preparedStatement.setInt(++n, this.timestamp);
            preparedStatement.setInt(++n, this.height);
            preparedStatement.executeUpdate();
        }
    }

    public long getBlockId() {
        return this.blockId;
    }

    public long getAskOrderId() {
        return this.askOrderId;
    }

    public long getBidOrderId() {
        return this.bidOrderId;
    }

    public int getAskOrderHeight() {
        return this.askOrderHeight;
    }

    public int getBidOrderHeight() {
        return this.bidOrderHeight;
    }

    public long getSellerId() {
        return this.sellerId;
    }

    public long getBuyerId() {
        return this.buyerId;
    }

    public long getQuantityQNT() {
        return this.quantityQNT;
    }

    public long getPriceNQT() {
        return this.priceNQT;
    }

    public long getAssetId() {
        return this.assetId;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isBuy() {
        return this.isBuy;
    }

    public String toString() {
        return "Trade asset: " + Long.toUnsignedString(this.assetId) + " ask: " + Long.toUnsignedString(this.askOrderId) + " bid: " + Long.toUnsignedString(this.bidOrderId) + " price: " + this.priceNQT + " quantity: " + this.quantityQNT + " height: " + this.height;
    }

    public static enum Event {
        TRADE;

    }
}

