/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import nxt.Account;
import nxt.Appendix;
import nxt.BlockDb;
import nxt.BlockchainImpl;
import nxt.BlockchainProcessorImpl;
import nxt.Constants;
import nxt.Db;
import nxt.Nxt;
import nxt.NxtException;
import nxt.Transaction;
import nxt.TransactionDb;
import nxt.TransactionImpl;
import nxt.TransactionProcessor;
import nxt.TransactionType;
import nxt.UnconfirmedTransaction;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.EntityDbTable;
import nxt.peer.Peer;
import nxt.peer.Peers;
import nxt.util.Convert;
import nxt.util.JSON;
import nxt.util.Listener;
import nxt.util.Listeners;
import nxt.util.Logger;
import nxt.util.ThreadPool;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

final class TransactionProcessorImpl
implements TransactionProcessor {
    private static final boolean enableTransactionRebroadcasting = Nxt.getBooleanProperty("nxt.enableTransactionRebroadcasting");
    private static final boolean testUnconfirmedTransactions = Nxt.getBooleanProperty("nxt.testUnconfirmedTransactions");
    private static final int maxUnconfirmedTransactions;
    private static final TransactionProcessorImpl instance;
    private final Map<DbKey, UnconfirmedTransaction> transactionCache = new HashMap<DbKey, UnconfirmedTransaction>();
    private volatile boolean cacheInitialized = false;
    final DbKey.LongKeyFactory<UnconfirmedTransaction> unconfirmedTransactionDbKeyFactory = new DbKey.LongKeyFactory<UnconfirmedTransaction>("id"){

        @Override
        public DbKey newKey(UnconfirmedTransaction unconfirmedTransaction) {
            return unconfirmedTransaction.getTransaction().getDbKey();
        }
    };
    private final EntityDbTable<UnconfirmedTransaction> unconfirmedTransactionTable = new EntityDbTable<UnconfirmedTransaction>("unconfirmed_transaction", this.unconfirmedTransactionDbKeyFactory){

        @Override
        protected UnconfirmedTransaction load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new UnconfirmedTransaction(resultSet);
        }

        @Override
        protected void save(Connection connection, UnconfirmedTransaction unconfirmedTransaction) throws SQLException {
            unconfirmedTransaction.save(connection);
            if (TransactionProcessorImpl.this.transactionCache.size() < maxUnconfirmedTransactions) {
                TransactionProcessorImpl.this.transactionCache.put(unconfirmedTransaction.getDbKey(), unconfirmedTransaction);
            }
        }

        @Override
        public void popOffTo(int n) {
            try (Connection connection = Db.db.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM unconfirmed_transaction WHERE height > ?");){
                preparedStatement.setInt(1, n);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        UnconfirmedTransaction unconfirmedTransaction = this.load(connection, resultSet, null);
                        TransactionProcessorImpl.this.waitingTransactions.add(unconfirmedTransaction);
                        TransactionProcessorImpl.this.transactionCache.remove(unconfirmedTransaction.getDbKey());
                    }
                }
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException.toString(), sQLException);
            }
            super.popOffTo(n);
            TransactionProcessorImpl.this.unconfirmedDuplicates.clear();
        }

        @Override
        public void truncate() {
            super.truncate();
            this.clearCache();
        }

        @Override
        protected String defaultSort() {
            return " ORDER BY transaction_height ASC, fee_per_byte DESC, arrival_timestamp ASC, id ASC ";
        }
    };
    private final Set<TransactionImpl> broadcastedTransactions = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Listeners<List<? extends Transaction>, TransactionProcessor.Event> transactionListeners = new Listeners();
    private final PriorityQueue<UnconfirmedTransaction> waitingTransactions = new PriorityQueue<UnconfirmedTransaction>((unconfirmedTransaction, unconfirmedTransaction2) -> {
        int n = Integer.compare(unconfirmedTransaction2.getHeight(), unconfirmedTransaction.getHeight());
        if (n != 0) {
            return n;
        }
        n = Boolean.compare(unconfirmedTransaction2.getTransaction().referencedTransactionFullHash() != null, unconfirmedTransaction.getTransaction().referencedTransactionFullHash() != null);
        if (n != 0) {
            return n;
        }
        n = Long.compare(unconfirmedTransaction.getFeePerByte(), unconfirmedTransaction2.getFeePerByte());
        if (n != 0) {
            return n;
        }
        n = Long.compare(unconfirmedTransaction2.getArrivalTimestamp(), unconfirmedTransaction.getArrivalTimestamp());
        if (n != 0) {
            return n;
        }
        return Long.compare(unconfirmedTransaction2.getId(), unconfirmedTransaction.getId());
    }){

        @Override
        public boolean add(UnconfirmedTransaction unconfirmedTransaction) {
            if (!super.add(unconfirmedTransaction)) {
                return false;
            }
            if (this.size() > maxUnconfirmedTransactions) {
                UnconfirmedTransaction unconfirmedTransaction2 = (UnconfirmedTransaction)this.remove();
            }
            return true;
        }
    };
    private final Map<TransactionType, Map<String, Integer>> unconfirmedDuplicates = new HashMap<TransactionType, Map<String, Integer>>();
    private final Runnable removeUnconfirmedTransactionsThread = () -> {
        block28: {
            try {
                try {
                    if (Nxt.getBlockchainProcessor().isDownloading() && !testUnconfirmedTransactions) {
                        return;
                    }
                    ArrayList<UnconfirmedTransaction> arrayList = new ArrayList<UnconfirmedTransaction>();
                    Throwable object2 = null;
                    try (Iterator<UnconfirmedTransaction> iterator = this.unconfirmedTransactionTable.getManyBy((DbClause)new DbClause.IntClause("expiration", DbClause.Op.LT, Nxt.getEpochTime()), 0, -1, "");){
                        while (((DbIterator)iterator).hasNext()) {
                            arrayList.add((UnconfirmedTransaction)((DbIterator)iterator).next());
                        }
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        throw throwable;
                    }
                    if (arrayList.size() <= 0) break block28;
                    BlockchainImpl.getInstance().writeLock();
                    try {
                        try {
                            Db.db.beginTransaction();
                            for (UnconfirmedTransaction unconfirmedTransaction : arrayList) {
                                this.removeUnconfirmedTransaction(unconfirmedTransaction.getTransaction());
                            }
                            Db.db.commitTransaction();
                        }
                        catch (Exception exception) {
                            Logger.logErrorMessage(exception.toString(), exception);
                            Db.db.rollbackTransaction();
                            throw exception;
                        }
                        finally {
                            Db.db.endTransaction();
                        }
                    }
                    finally {
                        BlockchainImpl.getInstance().writeUnlock();
                    }
                }
                catch (Exception exception) {
                    Logger.logMessage("Error removing unconfirmed transactions", exception);
                }
            }
            catch (Throwable throwable) {
                Logger.logErrorMessage("CRITICAL ERROR. PLEASE REPORT TO THE DEVELOPERS.\n" + throwable.toString());
                throwable.printStackTrace();
                System.exit(1);
            }
        }
    };
    private final Runnable rebroadcastTransactionsThread = () -> {
        try {
            try {
                if (Nxt.getBlockchainProcessor().isDownloading() && !testUnconfirmedTransactions) {
                    return;
                }
                ArrayList<TransactionImpl> arrayList = new ArrayList<TransactionImpl>();
                int n = Nxt.getEpochTime();
                for (TransactionImpl transactionImpl : this.broadcastedTransactions) {
                    if (transactionImpl.getExpiration() < n || TransactionDb.hasTransaction(transactionImpl.getId())) {
                        this.broadcastedTransactions.remove(transactionImpl);
                        continue;
                    }
                    if (transactionImpl.getTimestamp() >= n - 30) continue;
                    arrayList.add(transactionImpl);
                }
                if (arrayList.size() > 0) {
                    Peers.sendToSomePeers(arrayList);
                }
            }
            catch (Exception exception) {
                Logger.logMessage("Error in transaction re-broadcasting thread", exception);
            }
        }
        catch (Throwable throwable) {
            Logger.logErrorMessage("CRITICAL ERROR. PLEASE REPORT TO THE DEVELOPERS.\n" + throwable.toString());
            throwable.printStackTrace();
            System.exit(1);
        }
    };
    private final Runnable processTransactionsThread = () -> {
        try {
            try {
                if (Nxt.getBlockchainProcessor().isDownloading() && !testUnconfirmedTransactions) {
                    return;
                }
                Peer peer = Peers.getAnyPeer(Peer.State.CONNECTED, true);
                if (peer == null) {
                    return;
                }
                JSONObject jSONObject = new JSONObject();
                jSONObject.put((Object)"requestType", (Object)"getUnconfirmedTransactions");
                JSONArray jSONArray = new JSONArray();
                this.getAllUnconfirmedTransactionIds().forEach(l -> jSONArray.add((Object)Long.toUnsignedString(l)));
                Collections.sort(jSONArray);
                jSONObject.put((Object)"exclude", (Object)jSONArray);
                JSONObject jSONObject2 = peer.send(JSON.prepareRequest(jSONObject), 0xA00000);
                if (jSONObject2 == null) {
                    return;
                }
                JSONArray jSONArray2 = (JSONArray)jSONObject2.get((Object)"unconfirmedTransactions");
                if (jSONArray2 == null || jSONArray2.size() == 0) {
                    return;
                }
                try {
                    this.processPeerTransactions(jSONArray2);
                }
                catch (RuntimeException | NxtException.ValidationException exception) {
                    peer.blacklist(exception);
                }
            }
            catch (Exception exception) {
                Logger.logMessage("Error processing unconfirmed transactions", exception);
            }
        }
        catch (Throwable throwable) {
            Logger.logErrorMessage("CRITICAL ERROR. PLEASE REPORT TO THE DEVELOPERS.\n" + throwable.toString());
            throwable.printStackTrace();
            System.exit(1);
        }
    };
    private final Runnable processWaitingTransactionsThread = () -> {
        try {
            try {
                if (Nxt.getBlockchainProcessor().isDownloading() && !testUnconfirmedTransactions) {
                    return;
                }
                this.processWaitingTransactions();
            }
            catch (Exception exception) {
                Logger.logMessage("Error processing waiting transactions", exception);
            }
        }
        catch (Throwable throwable) {
            Logger.logErrorMessage("CRITICAL ERROR. PLEASE REPORT TO THE DEVELOPERS.\n" + throwable.toString());
            throwable.printStackTrace();
            System.exit(1);
        }
    };
    private static final Comparator<UnconfirmedTransaction> cachedUnconfirmedTransactionComparator;

    static TransactionProcessorImpl getInstance() {
        return instance;
    }

    private TransactionProcessorImpl() {
        if (!Constants.isLightClient) {
            if (!Constants.isOffline) {
                ThreadPool.scheduleThread("ProcessTransactions", this.processTransactionsThread, 5);
                ThreadPool.runAfterStart(this::rebroadcastAllUnconfirmedTransactions);
                ThreadPool.scheduleThread("RebroadcastTransactions", this.rebroadcastTransactionsThread, 23);
            }
            ThreadPool.scheduleThread("RemoveUnconfirmedTransactions", this.removeUnconfirmedTransactionsThread, 20);
            ThreadPool.scheduleThread("ProcessWaitingTransactions", this.processWaitingTransactionsThread, 1);
        }
    }

    @Override
    public boolean addListener(Listener<List<? extends Transaction>> listener, TransactionProcessor.Event event) {
        return this.transactionListeners.addListener(listener, event);
    }

    @Override
    public boolean removeListener(Listener<List<? extends Transaction>> listener, TransactionProcessor.Event event) {
        return this.transactionListeners.removeListener(listener, event);
    }

    void notifyListeners(List<? extends Transaction> list, TransactionProcessor.Event event) {
        this.transactionListeners.notify(list, event);
    }

    public DbIterator<UnconfirmedTransaction> getAllUnconfirmedTransactions() {
        return this.unconfirmedTransactionTable.getAll(0, -1);
    }

    public DbIterator<UnconfirmedTransaction> getAllUnconfirmedTransactions(int n, int n2) {
        return this.unconfirmedTransactionTable.getAll(n, n2);
    }

    public DbIterator<UnconfirmedTransaction> getAllUnconfirmedTransactions(String string) {
        return this.unconfirmedTransactionTable.getAll(0, -1, string);
    }

    public DbIterator<UnconfirmedTransaction> getAllUnconfirmedTransactions(int n, int n2, String string) {
        return this.unconfirmedTransactionTable.getAll(n, n2, string);
    }

    @Override
    public Transaction getUnconfirmedTransaction(long l) {
        DbKey dbKey = this.unconfirmedTransactionDbKeyFactory.newKey(l);
        return this.getUnconfirmedTransaction(dbKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transaction getUnconfirmedTransaction(DbKey dbKey) {
        Nxt.getBlockchain().readLock();
        try {
            Transaction transaction = this.transactionCache.get(dbKey);
            if (transaction != null) {
                Transaction transaction2 = transaction;
                return transaction2;
            }
        }
        finally {
            Nxt.getBlockchain().readUnlock();
        }
        return this.unconfirmedTransactionTable.get(dbKey);
    }

    private List<Long> getAllUnconfirmedTransactionIds() {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        try (Connection connection = Db.db.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT id FROM unconfirmed_transaction");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong("id"));
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        return arrayList;
    }

    public UnconfirmedTransaction[] getAllWaitingTransactions() {
        UnconfirmedTransaction[] unconfirmedTransactionArray;
        BlockchainImpl.getInstance().readLock();
        try {
            unconfirmedTransactionArray = this.waitingTransactions.toArray(new UnconfirmedTransaction[this.waitingTransactions.size()]);
        }
        finally {
            BlockchainImpl.getInstance().readUnlock();
        }
        Arrays.sort(unconfirmedTransactionArray, this.waitingTransactions.comparator());
        return unconfirmedTransactionArray;
    }

    Collection<UnconfirmedTransaction> getWaitingTransactions() {
        return Collections.unmodifiableCollection(this.waitingTransactions);
    }

    public TransactionImpl[] getAllBroadcastedTransactions() {
        BlockchainImpl.getInstance().readLock();
        try {
            TransactionImpl[] transactionImplArray = this.broadcastedTransactions.toArray(new TransactionImpl[this.broadcastedTransactions.size()]);
            return transactionImplArray;
        }
        finally {
            BlockchainImpl.getInstance().readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void broadcast(Transaction transaction) throws NxtException.ValidationException {
        BlockchainImpl.getInstance().writeLock();
        try {
            if (TransactionDb.hasTransaction(transaction.getId())) {
                Logger.logMessage("Transaction " + transaction.getStringId() + " already in blockchain, will not broadcast again");
                return;
            }
            if (this.getUnconfirmedTransaction(((TransactionImpl)transaction).getDbKey()) != null) {
                if (enableTransactionRebroadcasting) {
                    this.broadcastedTransactions.add((TransactionImpl)transaction);
                    Logger.logMessage("Transaction " + transaction.getStringId() + " already in unconfirmed pool, will re-broadcast");
                } else {
                    Logger.logMessage("Transaction " + transaction.getStringId() + " already in unconfirmed pool, will not broadcast again");
                }
                return;
            }
            transaction.validate();
            UnconfirmedTransaction unconfirmedTransaction = new UnconfirmedTransaction((TransactionImpl)transaction, System.currentTimeMillis());
            boolean bl = BlockchainProcessorImpl.getInstance().isProcessingBlock();
            if (bl) {
                this.waitingTransactions.add(unconfirmedTransaction);
                this.broadcastedTransactions.add((TransactionImpl)transaction);
                Logger.logDebugMessage("Will broadcast new transaction later " + transaction.getStringId());
            } else {
                this.processTransaction(unconfirmedTransaction);
                Logger.logDebugMessage("Accepted new transaction " + transaction.getStringId());
                List<Transaction> list = Collections.singletonList(transaction);
                Peers.sendToSomePeers(list);
                this.transactionListeners.notify(list, TransactionProcessor.Event.ADDED_UNCONFIRMED_TRANSACTIONS);
                if (enableTransactionRebroadcasting) {
                    this.broadcastedTransactions.add((TransactionImpl)transaction);
                }
            }
        }
        finally {
            BlockchainImpl.getInstance().writeUnlock();
        }
    }

    @Override
    public void processPeerTransactions(JSONObject jSONObject) throws NxtException.ValidationException {
        JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"transactions");
        this.processPeerTransactions(jSONArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearUnconfirmedTransactions() {
        BlockchainImpl.getInstance().writeLock();
        try {
            ArrayList<TransactionImpl> arrayList = new ArrayList<TransactionImpl>();
            try {
                Db.db.beginTransaction();
                try (DbIterator<UnconfirmedTransaction> dbIterator = this.getAllUnconfirmedTransactions();){
                    for (UnconfirmedTransaction unconfirmedTransaction : dbIterator) {
                        unconfirmedTransaction.getTransaction().undoUnconfirmed();
                        arrayList.add(unconfirmedTransaction.getTransaction());
                    }
                }
                this.unconfirmedTransactionTable.truncate();
                Db.db.commitTransaction();
            }
            catch (Exception exception) {
                Logger.logErrorMessage(exception.toString(), exception);
                Db.db.rollbackTransaction();
                throw exception;
            }
            finally {
                Db.db.endTransaction();
            }
            this.unconfirmedDuplicates.clear();
            this.waitingTransactions.clear();
            this.broadcastedTransactions.clear();
            this.transactionCache.clear();
            this.transactionListeners.notify(arrayList, TransactionProcessor.Event.REMOVED_UNCONFIRMED_TRANSACTIONS);
        }
        finally {
            BlockchainImpl.getInstance().writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requeueAllUnconfirmedTransactions() {
        BlockchainImpl.getInstance().writeLock();
        try {
            if (!Db.db.isInTransaction()) {
                try {
                    Db.db.beginTransaction();
                    this.requeueAllUnconfirmedTransactions();
                    Db.db.commitTransaction();
                }
                catch (Exception exception) {
                    Logger.logErrorMessage(exception.toString(), exception);
                    Db.db.rollbackTransaction();
                    throw exception;
                }
                finally {
                    Db.db.endTransaction();
                }
                return;
            }
            ArrayList<TransactionImpl> arrayList = new ArrayList<TransactionImpl>();
            try (DbIterator<UnconfirmedTransaction> dbIterator = this.getAllUnconfirmedTransactions();){
                for (UnconfirmedTransaction unconfirmedTransaction : dbIterator) {
                    unconfirmedTransaction.getTransaction().undoUnconfirmed();
                    if (arrayList.size() < maxUnconfirmedTransactions) {
                        arrayList.add(unconfirmedTransaction.getTransaction());
                    }
                    this.waitingTransactions.add(unconfirmedTransaction);
                }
            }
            this.unconfirmedTransactionTable.truncate();
            this.unconfirmedDuplicates.clear();
            this.transactionCache.clear();
            this.transactionListeners.notify(arrayList, TransactionProcessor.Event.REMOVED_UNCONFIRMED_TRANSACTIONS);
        }
        finally {
            BlockchainImpl.getInstance().writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebroadcastAllUnconfirmedTransactions() {
        BlockchainImpl.getInstance().writeLock();
        try (DbIterator<UnconfirmedTransaction> dbIterator = this.getAllUnconfirmedTransactions();){
            for (UnconfirmedTransaction unconfirmedTransaction : dbIterator) {
                if (unconfirmedTransaction.getTransaction().isUnconfirmedDuplicate(this.unconfirmedDuplicates)) {
                    Logger.logDebugMessage("Skipping duplicate unconfirmed transaction " + unconfirmedTransaction.getTransaction().getJSONObject().toString());
                    continue;
                }
                if (!enableTransactionRebroadcasting) continue;
                this.broadcastedTransactions.add(unconfirmedTransaction.getTransaction());
            }
        }
        finally {
            BlockchainImpl.getInstance().writeUnlock();
        }
    }

    void removeUnconfirmedTransaction(TransactionImpl transactionImpl) {
        if (!Db.db.isInTransaction()) {
            try {
                Db.db.beginTransaction();
                this.removeUnconfirmedTransaction(transactionImpl);
                Db.db.commitTransaction();
            }
            catch (Exception exception) {
                Logger.logErrorMessage(exception.toString(), exception);
                Db.db.rollbackTransaction();
                throw exception;
            }
            finally {
                Db.db.endTransaction();
            }
            return;
        }
        try (Connection connection = Db.db.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM unconfirmed_transaction WHERE id = ?");){
            preparedStatement.setLong(1, transactionImpl.getId());
            int n = preparedStatement.executeUpdate();
            if (n > 0) {
                transactionImpl.undoUnconfirmed();
                this.transactionCache.remove(transactionImpl.getDbKey());
                this.transactionListeners.notify(Collections.singletonList(transactionImpl), TransactionProcessor.Event.REMOVED_UNCONFIRMED_TRANSACTIONS);
            }
        }
        catch (SQLException sQLException) {
            Logger.logErrorMessage(sQLException.toString(), sQLException);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processLater(Collection<? extends Transaction> collection) {
        long l = System.currentTimeMillis();
        BlockchainImpl.getInstance().writeLock();
        try {
            for (Transaction transaction : collection) {
                BlockDb.transactionCache.remove(transaction.getId());
                if (TransactionDb.hasTransaction(transaction.getId())) continue;
                ((TransactionImpl)transaction).unsetBlock();
                this.waitingTransactions.add(new UnconfirmedTransaction((TransactionImpl)transaction, Math.min(l, Convert.fromEpochTime(transaction.getTimestamp()))));
            }
        }
        finally {
            BlockchainImpl.getInstance().writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processWaitingTransactions() {
        BlockchainImpl.getInstance().writeLock();
        try {
            if (this.waitingTransactions.size() > 0) {
                int n = Nxt.getEpochTime();
                ArrayList<TransactionImpl> arrayList = new ArrayList<TransactionImpl>();
                Iterator<UnconfirmedTransaction> iterator = this.waitingTransactions.iterator();
                while (iterator.hasNext()) {
                    UnconfirmedTransaction unconfirmedTransaction = iterator.next();
                    try {
                        unconfirmedTransaction.validate();
                        this.processTransaction(unconfirmedTransaction);
                        iterator.remove();
                        arrayList.add(unconfirmedTransaction.getTransaction());
                    }
                    catch (NxtException.ExistingTransactionException existingTransactionException) {
                        iterator.remove();
                    }
                    catch (NxtException.NotCurrentlyValidException notCurrentlyValidException) {
                        if (unconfirmedTransaction.getExpiration() >= n && n - Convert.toEpochTime(unconfirmedTransaction.getArrivalTimestamp()) <= 3600) continue;
                        iterator.remove();
                    }
                    catch (RuntimeException | NxtException.ValidationException exception) {
                        iterator.remove();
                    }
                }
                if (arrayList.size() > 0) {
                    this.transactionListeners.notify(arrayList, TransactionProcessor.Event.ADDED_UNCONFIRMED_TRANSACTIONS);
                }
            }
        }
        finally {
            BlockchainImpl.getInstance().writeUnlock();
        }
    }

    private void processPeerTransactions(JSONArray jSONArray) throws NxtException.NotValidException {
        if (Nxt.getBlockchain().getHeight() <= Constants.LAST_KNOWN_BLOCK && !testUnconfirmedTransactions) {
            return;
        }
        if (jSONArray == null || jSONArray.isEmpty()) {
            return;
        }
        long l = System.currentTimeMillis();
        ArrayList<TransactionImpl> arrayList = new ArrayList<TransactionImpl>();
        ArrayList<TransactionImpl> arrayList2 = new ArrayList<TransactionImpl>();
        ArrayList<TransactionImpl> arrayList3 = new ArrayList<TransactionImpl>();
        ArrayList<Exception> arrayList4 = new ArrayList<Exception>();
        for (Object e : jSONArray) {
            try {
                TransactionImpl transactionImpl = TransactionImpl.parseTransaction((JSONObject)e);
                arrayList.add(transactionImpl);
                if (this.getUnconfirmedTransaction(transactionImpl.getDbKey()) != null || TransactionDb.hasTransaction(transactionImpl.getId())) continue;
                transactionImpl.validate();
                UnconfirmedTransaction unconfirmedTransaction = new UnconfirmedTransaction(transactionImpl, l);
                this.processTransaction(unconfirmedTransaction);
                if (this.broadcastedTransactions.contains(transactionImpl)) {
                    Logger.logDebugMessage("Received back transaction " + transactionImpl.getStringId() + " that we broadcasted, will not forward again to peers");
                } else {
                    arrayList2.add(transactionImpl);
                }
                arrayList3.add(transactionImpl);
            }
            catch (NxtException.NotCurrentlyValidException notCurrentlyValidException) {
            }
            catch (RuntimeException | NxtException.ValidationException exception) {
                Logger.logDebugMessage(String.format("Invalid transaction from peer: %s", ((JSONObject)e).toJSONString()), exception);
                arrayList4.add(exception);
            }
        }
        if (arrayList2.size() > 0) {
            Peers.sendToSomePeers(arrayList2);
        }
        if (arrayList3.size() > 0) {
            this.transactionListeners.notify(arrayList3, TransactionProcessor.Event.ADDED_UNCONFIRMED_TRANSACTIONS);
        }
        this.broadcastedTransactions.removeAll(arrayList);
        if (!arrayList4.isEmpty()) {
            throw new NxtException.NotValidException("Peer sends invalid transactions: " + ((Object)arrayList4).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTransaction(UnconfirmedTransaction unconfirmedTransaction) throws NxtException.ValidationException {
        TransactionImpl transactionImpl = unconfirmedTransaction.getTransaction();
        int n = Nxt.getEpochTime();
        if (transactionImpl.getTimestamp() > n + 15 || transactionImpl.getExpiration() < n) {
            throw new NxtException.NotCurrentlyValidException("Invalid transaction timestamp");
        }
        if (transactionImpl.getVersion() < 1) {
            throw new NxtException.NotValidException("Invalid transaction version");
        }
        if (transactionImpl.getId() == 0L) {
            throw new NxtException.NotValidException("Invalid transaction id 0");
        }
        BlockchainImpl.getInstance().writeLock();
        try {
            try {
                Db.db.beginTransaction();
                if (Nxt.getBlockchain().getHeight() <= Constants.LAST_KNOWN_BLOCK && !testUnconfirmedTransactions) {
                    throw new NxtException.NotCurrentlyValidException("Blockchain not ready to accept transactions");
                }
                if (this.getUnconfirmedTransaction(transactionImpl.getDbKey()) != null || TransactionDb.hasTransaction(transactionImpl.getId())) {
                    throw new NxtException.ExistingTransactionException("Transaction already processed");
                }
                if (!transactionImpl.verifySignature()) {
                    if (Account.getAccount(transactionImpl.getSenderId()) != null) {
                        throw new NxtException.NotValidException("Transaction signature verification failed");
                    }
                    throw new NxtException.NotCurrentlyValidException("Unknown transaction sender");
                }
                if (!transactionImpl.applyUnconfirmed()) {
                    throw new NxtException.InsufficientBalanceException("Insufficient balance");
                }
                if (transactionImpl.isUnconfirmedDuplicate(this.unconfirmedDuplicates)) {
                    throw new NxtException.NotCurrentlyValidException("Duplicate unconfirmed transaction");
                }
                this.unconfirmedTransactionTable.insert(unconfirmedTransaction);
                Db.db.commitTransaction();
            }
            catch (Exception exception) {
                Db.db.rollbackTransaction();
                throw exception;
            }
            finally {
                Db.db.endTransaction();
            }
        }
        finally {
            BlockchainImpl.getInstance().writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSet<? extends Transaction> getCachedUnconfirmedTransactions(List<String> list) {
        TreeSet<UnconfirmedTransaction> treeSet = new TreeSet<UnconfirmedTransaction>(cachedUnconfirmedTransactionComparator);
        Nxt.getBlockchain().readLock();
        try {
            Map<DbKey, UnconfirmedTransaction> map = this.transactionCache;
            synchronized (map) {
                if (!this.cacheInitialized) {
                    DbIterator<UnconfirmedTransaction> dbIterator = this.getAllUnconfirmedTransactions();
                    while (dbIterator.hasNext()) {
                        UnconfirmedTransaction unconfirmedTransaction2 = dbIterator.next();
                        this.transactionCache.put(unconfirmedTransaction2.getDbKey(), unconfirmedTransaction2);
                    }
                    this.cacheInitialized = true;
                }
            }
            this.transactionCache.values().forEach(unconfirmedTransaction -> {
                if (Collections.binarySearch(list, unconfirmedTransaction.getStringId()) < 0) {
                    treeSet.add((UnconfirmedTransaction)unconfirmedTransaction);
                }
            });
        }
        finally {
            Nxt.getBlockchain().readUnlock();
        }
        return treeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Transaction> restorePrunableData(JSONArray jSONArray) throws NxtException.NotValidException {
        ArrayList<Transaction> arrayList = new ArrayList<Transaction>();
        Nxt.getBlockchain().readLock();
        try {
            Db.db.beginTransaction();
            try {
                for (Object e : jSONArray) {
                    TransactionImpl transactionImpl = TransactionImpl.parseTransaction((JSONObject)e);
                    TransactionImpl transactionImpl2 = TransactionDb.findTransactionByFullHash(transactionImpl.fullHash());
                    if (transactionImpl2 == null) continue;
                    boolean bl = true;
                    block9: for (Appendix.AbstractAppendix abstractAppendix : transactionImpl.getAppendages()) {
                        if (!(abstractAppendix instanceof Appendix.Prunable)) continue;
                        for (Appendix.AbstractAppendix abstractAppendix2 : transactionImpl2.getAppendages()) {
                            if (abstractAppendix2.getClass() != abstractAppendix.getClass()) continue;
                            abstractAppendix2.loadPrunable(transactionImpl2, true);
                            if (!((Appendix.Prunable)((Object)abstractAppendix2)).hasPrunableData()) break;
                            Logger.logDebugMessage(String.format("Already have prunable data for transaction %s %s appendage", transactionImpl2.getStringId(), abstractAppendix2.getAppendixName()));
                            continue block9;
                        }
                        if (((Appendix.Prunable)((Object)abstractAppendix)).hasPrunableData()) {
                            Logger.logDebugMessage(String.format("Loading prunable data for transaction %s %s appendage", Long.toUnsignedString(transactionImpl.getId()), abstractAppendix.getAppendixName()));
                            ((Appendix.Prunable)((Object)abstractAppendix)).restorePrunableData(transactionImpl, transactionImpl2.getBlockTimestamp(), transactionImpl2.getHeight());
                            continue;
                        }
                        bl = false;
                    }
                    if (bl) {
                        arrayList.add(transactionImpl2);
                    }
                    Db.db.clearCache();
                    Db.db.commitTransaction();
                }
                Db.db.commitTransaction();
            }
            catch (Exception exception) {
                Db.db.rollbackTransaction();
                arrayList.clear();
                throw exception;
            }
            finally {
                Db.db.endTransaction();
            }
        }
        finally {
            Nxt.getBlockchain().readUnlock();
        }
        return arrayList;
    }

    static {
        int n = Nxt.getIntProperty("nxt.maxUnconfirmedTransactions");
        maxUnconfirmedTransactions = n <= 0 ? Integer.MAX_VALUE : n;
        instance = new TransactionProcessorImpl();
        cachedUnconfirmedTransactionComparator = (unconfirmedTransaction, unconfirmedTransaction2) -> {
            int n = Integer.compare(unconfirmedTransaction.getHeight(), unconfirmedTransaction2.getHeight());
            if (n != 0) {
                return n;
            }
            n = Long.compare(unconfirmedTransaction.getFeePerByte(), unconfirmedTransaction2.getFeePerByte());
            if (n != 0) {
                return -n;
            }
            n = Long.compare(unconfirmedTransaction.getArrivalTimestamp(), unconfirmedTransaction2.getArrivalTimestamp());
            if (n != 0) {
                return n;
            }
            return Long.compare(unconfirmedTransaction.getId(), unconfirmedTransaction2.getId());
        };
    }
}

