/*
 * Decompiled with CFR 0.152.
 */
package nxt.crypto;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Locale;
import nxt.Nxt;
import nxt.crypto.Curve25519;
import nxt.crypto.ReedSolomon;
import nxt.util.Convert;
import nxt.util.Logger;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.jcajce.provider.digest.Keccak;
import org.bouncycastle.jcajce.provider.digest.RIPEMD160;

public final class Crypto {
    private static final boolean useStrongSecureRandom = Nxt.getBooleanProperty("nxt.useStrongSecureRandom");
    private static final ThreadLocal<SecureRandom> secureRandom = ThreadLocal.withInitial(() -> {
        try {
            SecureRandom secureRandom = useStrongSecureRandom ? SecureRandom.getInstanceStrong() : new SecureRandom();
            secureRandom.nextBoolean();
            return secureRandom;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Logger.logErrorMessage("No secure random provider available");
            throw new RuntimeException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
    });

    private Crypto() {
    }

    public static SecureRandom getSecureRandom() {
        return secureRandom.get();
    }

    public static MessageDigest getMessageDigest(String string) {
        try {
            return MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Logger.logMessage("Missing message digest algorithm: " + string);
            throw new RuntimeException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
    }

    public static MessageDigest sha256() {
        return Crypto.getMessageDigest("SHA-256");
    }

    public static MessageDigest ripemd160() {
        return new RIPEMD160.Digest();
    }

    public static MessageDigest sha3() {
        return new Keccak.Digest256();
    }

    public static byte[] getKeySeed(String string, byte[] ... byArray) {
        MessageDigest messageDigest = Crypto.sha256();
        messageDigest.update(Convert.toBytes(string));
        for (byte[] byArray2 : byArray) {
            messageDigest.update(byArray2);
        }
        return messageDigest.digest();
    }

    public static byte[] getPublicKey(byte[] byArray) {
        byte[] byArray2 = new byte[32];
        Curve25519.keygen(byArray2, null, Arrays.copyOf(byArray, byArray.length));
        return byArray2;
    }

    public static byte[] getPublicKey(String string) {
        byte[] byArray = new byte[32];
        Curve25519.keygen(byArray, null, Crypto.sha256().digest(Convert.toBytes(string)));
        return byArray;
    }

    public static byte[] getPrivateKey(byte[] byArray) {
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Curve25519.clamp(byArray2);
        return byArray2;
    }

    public static byte[] getPrivateKey(String string) {
        byte[] byArray = Crypto.sha256().digest(Convert.toBytes(string));
        Curve25519.clamp(byArray);
        return byArray;
    }

    public static void curve(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        Curve25519.curve(byArray, byArray2, byArray3);
    }

    public static byte[] sign(byte[] byArray, String string) {
        byte[] byArray2 = new byte[32];
        byte[] byArray3 = new byte[32];
        MessageDigest messageDigest = Crypto.sha256();
        Curve25519.keygen(byArray2, byArray3, messageDigest.digest(Convert.toBytes(string)));
        byte[] byArray4 = messageDigest.digest(byArray);
        messageDigest.update(byArray4);
        byte[] byArray5 = messageDigest.digest(byArray3);
        byte[] byArray6 = new byte[32];
        Curve25519.keygen(byArray6, null, byArray5);
        messageDigest.update(byArray4);
        byte[] byArray7 = messageDigest.digest(byArray6);
        byte[] byArray8 = new byte[32];
        Curve25519.sign(byArray8, byArray7, byArray5, byArray3);
        byte[] byArray9 = new byte[64];
        System.arraycopy(byArray8, 0, byArray9, 0, 32);
        System.arraycopy(byArray7, 0, byArray9, 32, 32);
        return byArray9;
    }

    public static boolean verify(byte[] byArray, byte[] byArray2, byte[] byArray3, boolean bl) {
        try {
            if (byArray.length != 64) {
                return false;
            }
            if (bl && !Curve25519.isCanonicalSignature(byArray)) {
                Logger.logDebugMessage("Rejecting non-canonical signature");
                return false;
            }
            if (bl && !Curve25519.isCanonicalPublicKey(byArray3)) {
                Logger.logDebugMessage("Rejecting non-canonical public key");
                return false;
            }
            byte[] byArray4 = new byte[32];
            byte[] byArray5 = new byte[32];
            System.arraycopy(byArray, 0, byArray5, 0, 32);
            byte[] byArray6 = new byte[32];
            System.arraycopy(byArray, 32, byArray6, 0, 32);
            Curve25519.verify(byArray4, byArray5, byArray6, byArray3);
            MessageDigest messageDigest = Crypto.sha256();
            byte[] byArray7 = messageDigest.digest(byArray2);
            messageDigest.update(byArray7);
            byte[] byArray8 = messageDigest.digest(byArray4);
            return Arrays.equals(byArray6, byArray8);
        }
        catch (RuntimeException runtimeException) {
            Logger.logErrorMessage("Error verifying signature", runtimeException);
            return false;
        }
    }

    public static byte[] getSharedKey(byte[] byArray, byte[] byArray2) {
        return Crypto.sha256().digest(Crypto.getSharedSecret(byArray, byArray2));
    }

    public static byte[] getSharedKey(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = Crypto.getSharedSecret(byArray, byArray2);
        for (int i = 0; i < 32; ++i) {
            int n = i;
            byArray4[n] = (byte)(byArray4[n] ^ byArray3[i]);
        }
        return Crypto.sha256().digest(byArray4);
    }

    private static byte[] getSharedSecret(byte[] byArray, byte[] byArray2) {
        try {
            byte[] byArray3 = new byte[32];
            Curve25519.curve(byArray3, byArray, byArray2);
            return byArray3;
        }
        catch (RuntimeException runtimeException) {
            Logger.logMessage("Error getting shared secret", runtimeException);
            throw runtimeException;
        }
    }

    public static byte[] aesEncrypt(byte[] byArray, byte[] byArray2) {
        try {
            byte[] byArray3 = new byte[16];
            secureRandom.get().nextBytes(byArray3);
            PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()));
            ParametersWithIV parametersWithIV = new ParametersWithIV((CipherParameters)new KeyParameter(byArray2), byArray3);
            paddedBufferedBlockCipher.init(true, (CipherParameters)parametersWithIV);
            byte[] byArray4 = new byte[paddedBufferedBlockCipher.getOutputSize(byArray.length)];
            int n = paddedBufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray4, 0);
            n += paddedBufferedBlockCipher.doFinal(byArray4, n);
            byte[] byArray5 = new byte[byArray3.length + n];
            System.arraycopy(byArray3, 0, byArray5, 0, byArray3.length);
            System.arraycopy(byArray4, 0, byArray5, byArray3.length, n);
            return byArray5;
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new RuntimeException(invalidCipherTextException.getMessage(), invalidCipherTextException);
        }
    }

    public static byte[] aesGCMEncrypt(byte[] byArray, byte[] byArray2) {
        try {
            byte[] byArray3 = new byte[16];
            secureRandom.get().nextBytes(byArray3);
            GCMBlockCipher gCMBlockCipher = new GCMBlockCipher((BlockCipher)new AESEngine());
            ParametersWithIV parametersWithIV = new ParametersWithIV((CipherParameters)new KeyParameter(byArray2), byArray3);
            gCMBlockCipher.init(true, (CipherParameters)parametersWithIV);
            byte[] byArray4 = new byte[gCMBlockCipher.getOutputSize(byArray.length)];
            int n = gCMBlockCipher.processBytes(byArray, 0, byArray.length, byArray4, 0);
            n += gCMBlockCipher.doFinal(byArray4, n);
            byte[] byArray5 = new byte[byArray3.length + n];
            System.arraycopy(byArray3, 0, byArray5, 0, byArray3.length);
            System.arraycopy(byArray4, 0, byArray5, byArray3.length, n);
            return byArray5;
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new RuntimeException(invalidCipherTextException.getMessage(), invalidCipherTextException);
        }
    }

    public static byte[] aesDecrypt(byte[] byArray, byte[] byArray2) {
        try {
            if (byArray.length < 16 || byArray.length % 16 != 0) {
                throw new InvalidCipherTextException("invalid ivCiphertext length");
            }
            byte[] byArray3 = Arrays.copyOfRange(byArray, 0, 16);
            byte[] byArray4 = Arrays.copyOfRange(byArray, 16, byArray.length);
            PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()));
            ParametersWithIV parametersWithIV = new ParametersWithIV((CipherParameters)new KeyParameter(byArray2), byArray3);
            paddedBufferedBlockCipher.init(false, (CipherParameters)parametersWithIV);
            byte[] byArray5 = new byte[paddedBufferedBlockCipher.getOutputSize(byArray4.length)];
            int n = paddedBufferedBlockCipher.processBytes(byArray4, 0, byArray4.length, byArray5, 0);
            n += paddedBufferedBlockCipher.doFinal(byArray5, n);
            byte[] byArray6 = new byte[n];
            System.arraycopy(byArray5, 0, byArray6, 0, byArray6.length);
            return byArray6;
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new RuntimeException(invalidCipherTextException.getMessage(), invalidCipherTextException);
        }
    }

    public static byte[] aesGCMDecrypt(byte[] byArray, byte[] byArray2) {
        try {
            if (byArray.length < 16) {
                throw new InvalidCipherTextException("invalid ivCiphertext length");
            }
            byte[] byArray3 = Arrays.copyOfRange(byArray, 0, 16);
            byte[] byArray4 = Arrays.copyOfRange(byArray, 16, byArray.length);
            GCMBlockCipher gCMBlockCipher = new GCMBlockCipher((BlockCipher)new AESEngine());
            ParametersWithIV parametersWithIV = new ParametersWithIV((CipherParameters)new KeyParameter(byArray2), byArray3);
            gCMBlockCipher.init(false, (CipherParameters)parametersWithIV);
            byte[] byArray5 = new byte[gCMBlockCipher.getOutputSize(byArray4.length)];
            int n = gCMBlockCipher.processBytes(byArray4, 0, byArray4.length, byArray5, 0);
            n += gCMBlockCipher.doFinal(byArray5, n);
            byte[] byArray6 = new byte[n];
            System.arraycopy(byArray5, 0, byArray6, 0, byArray6.length);
            return byArray6;
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new RuntimeException(invalidCipherTextException.getMessage(), invalidCipherTextException);
        }
    }

    public static String rsEncode(long l) {
        return ReedSolomon.encode(l);
    }

    public static long rsDecode(String string) {
        string = string.toUpperCase(Locale.ROOT);
        try {
            long l = ReedSolomon.decode(string);
            if (!string.equals(ReedSolomon.encode(l))) {
                throw new RuntimeException("ERROR: Reed-Solomon decoding of " + string + " not reversible, decoded to " + l);
            }
            return l;
        }
        catch (ReedSolomon.DecodeException decodeException) {
            Logger.logDebugMessage("Reed-Solomon decoding failed for " + string + ": " + decodeException.toString());
            throw new RuntimeException(decodeException.toString(), decodeException);
        }
    }

    public static boolean isCanonicalPublicKey(byte[] byArray) {
        return Curve25519.isCanonicalPublicKey(byArray);
    }

    public static boolean isCanonicalSignature(byte[] byArray) {
        return Curve25519.isCanonicalSignature(byArray);
    }
}

