/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Attachment;
import nxt.NxtException;
import nxt.Poll;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public final class CastVote
extends CreateTransaction {
    static final CastVote instance = new CastVote();

    private CastVote() {
        super(new APITag[]{APITag.VS, APITag.CREATE_TRANSACTION}, "poll", "vote00", "vote01", "vote02");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Object object;
        Poll poll = ParameterParser.getPoll(httpServletRequest);
        if (poll.isFinished()) {
            return JSONResponses.POLL_FINISHED;
        }
        int n = poll.getOptions().length;
        byte[] byArray = new byte[n];
        try {
            for (int i = 0; i < n; ++i) {
                object = Convert.emptyToNull(httpServletRequest.getParameter("vote" + (i < 10 ? "0" + i : Integer.valueOf(i))));
                if (object != null) {
                    byArray[i] = Byte.parseByte((String)object);
                    if (byArray[i] == -128 || byArray[i] >= poll.getMinRangeValue() && byArray[i] <= poll.getMaxRangeValue()) continue;
                    return JSONResponses.INCORRECT_VOTE;
                }
                byArray[i] = -128;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return JSONResponses.INCORRECT_VOTE;
        }
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        object = new Attachment.MessagingVoteCasting(poll.getId(), byArray);
        return this.createTransaction(httpServletRequest, account, (Attachment)object);
    }
}

