/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Asset;
import nxt.Attachment;
import nxt.NxtException;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public class DeleteAssetProperty
extends CreateTransaction {
    static final DeleteAssetProperty instance = new DeleteAssetProperty();

    private DeleteAssetProperty() {
        super(new APITag[]{APITag.AE, APITag.CREATE_TRANSACTION}, "asset", "property", "setter");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        String string;
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        Asset asset = ParameterParser.getAsset(httpServletRequest);
        long l = ParameterParser.getAccountId(httpServletRequest, "setter", false);
        if (l == 0L) {
            l = account.getId();
        }
        if ((string = Convert.nullToEmpty(httpServletRequest.getParameter("property")).trim()).isEmpty()) {
            return JSONResponses.MISSING_PROPERTY;
        }
        Asset.AssetProperty assetProperty = asset.getProperty(l, string);
        if (assetProperty == null) {
            return JSONResponses.UNKNOWN_PROPERTY;
        }
        if (assetProperty.getSetterId() != account.getId() && asset.getAccountId() != account.getId()) {
            return JSONResponses.INCORRECT_PROPERTY;
        }
        Attachment.ColoredCoinsAssetPropertyDelete coloredCoinsAssetPropertyDelete = new Attachment.ColoredCoinsAssetPropertyDelete(assetProperty.getId());
        return this.createTransaction(httpServletRequest, account, asset.getAccountId(), 0L, coloredCoinsAssetPropertyDelete);
    }
}

