/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Asset;
import nxt.Attachment;
import nxt.Constants;
import nxt.HoldingType;
import nxt.Nxt;
import nxt.NxtException;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONStreamAware;

public class DividendPayment
extends CreateTransaction {
    static final DividendPayment instance = new DividendPayment();

    private DividendPayment() {
        super(new APITag[]{APITag.AE, APITag.CREATE_TRANSACTION}, "holding", "holdingType", "asset", "height", "amountNQTPerQNT");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Attachment.ColoredCoinsDividendPayment coloredCoinsDividendPayment;
        long l;
        int n = ParameterParser.getHeight(httpServletRequest, true);
        long l2 = ParameterParser.getAmountNQTPerQNT(httpServletRequest);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        Asset asset = ParameterParser.getAsset(httpServletRequest);
        if (Asset.getAsset(asset.getId(), n) == null) {
            return JSONResponses.ASSET_NOT_ISSUED_YET;
        }
        HoldingType holdingType = ParameterParser.getHoldingType(httpServletRequest);
        long l3 = l = holdingType != HoldingType.NXT ? ParameterParser.getHoldingId(httpServletRequest, holdingType) : 0L;
        if (Nxt.getBlockchain().getHeight() < Constants.ASSET_INCREASE_BLOCK) {
            if (holdingType != HoldingType.NXT) {
                return JSONResponses.FEATURE_NOT_AVAILABLE;
            }
            coloredCoinsDividendPayment = new Attachment.ColoredCoinsDividendPayment(asset.getId(), n, l2);
        } else {
            coloredCoinsDividendPayment = new Attachment.ColoredCoinsDividendPayment(l, holdingType, asset.getId(), n, l2);
        }
        try {
            return this.createTransaction(httpServletRequest, account, coloredCoinsDividendPayment);
        }
        catch (NxtException.InsufficientBalanceException insufficientBalanceException) {
            return JSONResponses.NOT_ENOUGH_FUNDS;
        }
    }
}

