/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Currency;
import nxt.NxtException;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public final class GetCurrency
extends APIServlet.APIRequestHandler {
    static final GetCurrency instance = new GetCurrency();

    private GetCurrency() {
        super(new APITag[]{APITag.MS}, "currency", "code", "includeCounts");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Currency currency;
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeCounts"));
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "currency", false);
        if (l == 0L) {
            String string = Convert.emptyToNull(httpServletRequest.getParameter("code"));
            if (string == null) {
                return JSONResponses.MISSING_CURRENCY;
            }
            currency = Currency.getCurrencyByCode(string);
        } else {
            currency = Currency.getCurrency(l);
        }
        if (currency == null) {
            throw new ParameterException(JSONResponses.UNKNOWN_CURRENCY);
        }
        return JSONData.currency(currency, bl);
    }
}

