/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Exchange;
import nxt.NxtException;
import nxt.db.DbIterator;
import nxt.db.DbUtils;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetExchanges
extends APIServlet.APIRequestHandler {
    static final GetExchanges instance = new GetExchanges();

    private GetExchanges() {
        super(new APITag[]{APITag.MS}, "currency", "account", "firstIndex", "lastIndex", "timestamp", "includeCurrencyInfo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        int n = ParameterParser.getTimestamp(httpServletRequest);
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "currency", false);
        long l2 = ParameterParser.getAccountId(httpServletRequest, false);
        if (l == 0L && l2 == 0L) {
            return JSONResponses.MISSING_CURRENCY_ACCOUNT;
        }
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeCurrencyInfo"));
        int n2 = ParameterParser.getFirstIndex(httpServletRequest);
        int n3 = ParameterParser.getLastIndex(httpServletRequest);
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        DbIterator<Exchange> dbIterator = null;
        try {
            Exchange exchange;
            dbIterator = l2 == 0L ? Exchange.getCurrencyExchanges(l, n2, n3) : (l == 0L ? Exchange.getAccountExchanges(l2, n2, n3) : Exchange.getAccountCurrencyExchanges(l2, l, n2, n3));
            while (dbIterator.hasNext() && (exchange = dbIterator.next()).getTimestamp() >= n) {
                jSONArray.add((Object)JSONData.exchange(exchange, bl));
            }
        }
        catch (Throwable throwable) {
            DbUtils.close(dbIterator);
            throw throwable;
        }
        DbUtils.close(dbIterator);
        jSONObject.put((Object)"exchanges", (Object)jSONArray);
        return jSONObject;
    }

    @Override
    protected boolean startDbTransaction() {
        return true;
    }
}

