/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Generator;
import nxt.Nxt;
import nxt.crypto.Crypto;
import nxt.http.API;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetForging
extends APIServlet.APIRequestHandler {
    static final GetForging instance = new GetForging();

    private GetForging() {
        super(new APITag[]{APITag.FORGING}, "secretPhrase", "adminPassword");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        String string = ParameterParser.getSecretPhrase(httpServletRequest, false);
        int n = Nxt.getEpochTime() - Nxt.getBlockchain().getLastBlock().getTimestamp();
        if (string != null) {
            Account account = Account.getAccount(Crypto.getPublicKey(string));
            if (account == null) {
                return JSONResponses.UNKNOWN_ACCOUNT;
            }
            Generator generator2 = Generator.getGenerator(string);
            if (generator2 == null) {
                return JSONResponses.NOT_FORGING;
            }
            return JSONData.generator(generator2, n);
        }
        API.verifyPassword(httpServletRequest);
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        Generator.getSortedForgers().forEach(generator -> jSONArray.add((Object)JSONData.generator(generator, n)));
        jSONObject.put((Object)"generators", (Object)jSONArray);
        return jSONObject;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireFullClient() {
        return true;
    }
}

