/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import nxt.Block;
import nxt.Hub;
import nxt.Nxt;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetNextBlockGenerators
extends APIServlet.APIRequestHandler {
    static final GetNextBlockGenerators instance = new GetNextBlockGenerators();

    private GetNextBlockGenerators() {
        super(new APITag[]{APITag.FORGING}, new String[0]);
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        int n;
        Block block = Nxt.getBlockchain().getLastBlock();
        if (block.getHeight() < Integer.MAX_VALUE) {
            return JSONResponses.FEATURE_NOT_AVAILABLE;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"time", (Object)Nxt.getEpochTime());
        jSONObject.put((Object)"lastBlock", (Object)Long.toUnsignedString(block.getId()));
        JSONArray jSONArray = new JSONArray();
        try {
            n = Integer.parseInt(httpServletRequest.getParameter("limit"));
        }
        catch (RuntimeException runtimeException) {
            n = Integer.MAX_VALUE;
        }
        Iterator<Hub.Hit> iterator = Hub.getHubHits(block).iterator();
        while (iterator.hasNext() && jSONArray.size() < n) {
            JSONObject jSONObject2 = new JSONObject();
            Hub.Hit hit = iterator.next();
            jSONObject2.put((Object)"account", (Object)Long.toUnsignedString(hit.hub.getAccountId()));
            jSONObject2.put((Object)"minFeePerByteNQT", (Object)hit.hub.getMinFeePerByteNQT());
            jSONObject2.put((Object)"time", (Object)hit.hitTime);
            JSONArray jSONArray2 = new JSONArray();
            jSONArray2.addAll(hit.hub.getUris());
            jSONObject2.put((Object)"uris", (Object)jSONArray2);
            jSONArray.add((Object)jSONObject2);
        }
        jSONObject.put((Object)"hubs", (Object)jSONArray);
        return jSONObject;
    }
}

