/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.Poll;
import nxt.VoteWeighting;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public class GetPollResult
extends APIServlet.APIRequestHandler {
    static final GetPollResult instance = new GetPollResult();

    private GetPollResult() {
        super(new APITag[]{APITag.VS}, "poll", "votingModel", "holding", "minBalance", "minBalanceModel");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        VoteWeighting voteWeighting;
        List<Poll.OptionResult> list;
        Poll poll = ParameterParser.getPoll(httpServletRequest);
        if (Convert.emptyToNull(httpServletRequest.getParameter("votingModel")) == null) {
            list = poll.getResults();
            voteWeighting = poll.getVoteWeighting();
        } else {
            byte by = ParameterParser.getByte(httpServletRequest, "votingModel", (byte)0, (byte)3, true);
            long l = ParameterParser.getLong(httpServletRequest, "holding", Long.MIN_VALUE, Long.MAX_VALUE, false);
            long l2 = ParameterParser.getLong(httpServletRequest, "minBalance", 0L, Long.MAX_VALUE, false);
            byte by2 = ParameterParser.getByte(httpServletRequest, "minBalanceModel", (byte)0, (byte)3, false);
            voteWeighting = new VoteWeighting(by, l, l2, by2);
            voteWeighting.validate();
            list = poll.getResults(voteWeighting);
        }
        if (list == null) {
            return JSONResponses.POLL_RESULTS_NOT_AVAILABLE;
        }
        return JSONData.pollResults(poll, list, voteWeighting);
    }
}

