/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.NxtException;
import nxt.Poll;
import nxt.Vote;
import nxt.VoteWeighting;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import nxt.util.JSON;
import org.json.simple.JSONStreamAware;

public class GetPollVote
extends APIServlet.APIRequestHandler {
    static final GetPollVote instance = new GetPollVote();

    private GetPollVote() {
        super(new APITag[]{APITag.VS}, "poll", "account", "includeWeights");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Poll poll = ParameterParser.getPoll(httpServletRequest);
        long l2 = ParameterParser.getAccountId(httpServletRequest, true);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeWeights"));
        Vote vote = Vote.getVote(poll.getId(), l2);
        if (vote != null) {
            int n;
            JSONData.VoteWeighter voteWeighter = null;
            if (bl && (n = Math.min(poll.getFinishHeight(), Nxt.getBlockchain().getHeight())) >= Nxt.getBlockchainProcessor().getMinRollbackHeight()) {
                VoteWeighting voteWeighting = poll.getVoteWeighting();
                VoteWeighting.VotingModel votingModel = voteWeighting.getVotingModel();
                voteWeighter = l -> votingModel.calcWeight(voteWeighting, l, n);
            }
            return JSONData.vote(vote, voteWeighter);
        }
        return JSON.emptyJSON;
    }
}

