/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.NxtException;
import nxt.PrunableMessage;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.JSON;
import org.json.simple.JSONStreamAware;

public final class GetPrunableMessage
extends APIServlet.APIRequestHandler {
    static final GetPrunableMessage instance = new GetPrunableMessage();

    private GetPrunableMessage() {
        super(new APITag[]{APITag.MESSAGES}, "transaction", "secretPhrase", "sharedKey", "retrieve");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "transaction", true);
        String string = ParameterParser.getSecretPhrase(httpServletRequest, false);
        byte[] byArray = ParameterParser.getBytes(httpServletRequest, "sharedKey", false);
        if (byArray.length != 0 && string != null) {
            return JSONResponses.either("secretPhrase", "sharedKey");
        }
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("retrieve"));
        PrunableMessage prunableMessage = PrunableMessage.getPrunableMessage(l);
        if (prunableMessage == null && bl) {
            if (Nxt.getBlockchainProcessor().restorePrunedTransaction(l) == null) {
                return JSONResponses.PRUNED_TRANSACTION;
            }
            prunableMessage = PrunableMessage.getPrunableMessage(l);
        }
        if (prunableMessage != null) {
            return JSONData.prunableMessage(prunableMessage, string, byArray);
        }
        return JSON.emptyJSON;
    }
}

