/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.net.InetAddress;
import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.AccountRestrictions;
import nxt.Alias;
import nxt.Asset;
import nxt.AssetTransfer;
import nxt.Constants;
import nxt.Currency;
import nxt.CurrencyBuyOffer;
import nxt.CurrencyTransfer;
import nxt.DigitalGoodsStore;
import nxt.Exchange;
import nxt.ExchangeRequest;
import nxt.Generator;
import nxt.Nxt;
import nxt.Order;
import nxt.Poll;
import nxt.PrunableMessage;
import nxt.Shuffling;
import nxt.TaggedData;
import nxt.Trade;
import nxt.Vote;
import nxt.http.API;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.GetBlockchainStatus;
import nxt.peer.Peers;
import nxt.util.UPnP;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetState
extends APIServlet.APIRequestHandler {
    static final GetState instance = new GetState();

    private GetState() {
        super(new APITag[]{APITag.INFO}, "includeCounts", "adminPassword");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        JSONObject jSONObject = GetBlockchainStatus.instance.processRequest(httpServletRequest);
        if ("true".equalsIgnoreCase(httpServletRequest.getParameter("includeCounts")) && API.checkPassword(httpServletRequest)) {
            jSONObject.put((Object)"numberOfTransactions", (Object)Nxt.getBlockchain().getTransactionCount());
            jSONObject.put((Object)"numberOfAccounts", (Object)Account.getCount());
            jSONObject.put((Object)"numberOfAssets", (Object)Asset.getCount());
            int n = Order.Ask.getCount();
            int n2 = Order.Bid.getCount();
            jSONObject.put((Object)"numberOfOrders", (Object)(n + n2));
            jSONObject.put((Object)"numberOfAskOrders", (Object)n);
            jSONObject.put((Object)"numberOfBidOrders", (Object)n2);
            jSONObject.put((Object)"numberOfTrades", (Object)Trade.getCount());
            jSONObject.put((Object)"numberOfTransfers", (Object)AssetTransfer.getCount());
            jSONObject.put((Object)"numberOfCurrencies", (Object)Currency.getCount());
            jSONObject.put((Object)"numberOfOffers", (Object)CurrencyBuyOffer.getCount());
            jSONObject.put((Object)"numberOfExchangeRequests", (Object)ExchangeRequest.getCount());
            jSONObject.put((Object)"numberOfExchanges", (Object)Exchange.getCount());
            jSONObject.put((Object)"numberOfCurrencyTransfers", (Object)CurrencyTransfer.getCount());
            jSONObject.put((Object)"numberOfAliases", (Object)Alias.getCount());
            jSONObject.put((Object)"numberOfGoods", (Object)DigitalGoodsStore.Goods.getCount());
            jSONObject.put((Object)"numberOfPurchases", (Object)DigitalGoodsStore.Purchase.getCount());
            jSONObject.put((Object)"numberOfTags", (Object)DigitalGoodsStore.Tag.getCount());
            jSONObject.put((Object)"numberOfPolls", (Object)Poll.getCount());
            jSONObject.put((Object)"numberOfVotes", (Object)Vote.getCount());
            jSONObject.put((Object)"numberOfPrunableMessages", (Object)PrunableMessage.getCount());
            jSONObject.put((Object)"numberOfTaggedData", (Object)TaggedData.getCount());
            jSONObject.put((Object)"numberOfDataTags", (Object)TaggedData.Tag.getTagCount());
            jSONObject.put((Object)"numberOfAccountLeases", (Object)Account.getAccountLeaseCount());
            jSONObject.put((Object)"numberOfActiveAccountLeases", (Object)Account.getActiveLeaseCount());
            jSONObject.put((Object)"numberOfShufflings", (Object)Shuffling.getCount());
            jSONObject.put((Object)"numberOfActiveShufflings", (Object)Shuffling.getActiveCount());
            jSONObject.put((Object)"numberOfPhasingOnlyAccounts", (Object)AccountRestrictions.PhasingOnly.getCount());
        }
        jSONObject.put((Object)"numberOfPeers", (Object)Peers.getAllPeers().size());
        jSONObject.put((Object)"numberOfActivePeers", (Object)Peers.getActivePeers().size());
        jSONObject.put((Object)"numberOfUnlockedAccounts", (Object)Generator.getAllGenerators().size());
        jSONObject.put((Object)"availableProcessors", (Object)Runtime.getRuntime().availableProcessors());
        jSONObject.put((Object)"maxMemory", (Object)Runtime.getRuntime().maxMemory());
        jSONObject.put((Object)"totalMemory", (Object)Runtime.getRuntime().totalMemory());
        jSONObject.put((Object)"freeMemory", (Object)Runtime.getRuntime().freeMemory());
        jSONObject.put((Object)"peerPort", (Object)Peers.getDefaultPeerPort());
        jSONObject.put((Object)"isOffline", (Object)Constants.isOffline);
        jSONObject.put((Object)"needsAdminPassword", (Object)(!API.disableAdminPassword ? 1 : 0));
        jSONObject.put((Object)"customLoginWarning", (Object)Constants.customLoginWarning);
        InetAddress inetAddress = UPnP.getExternalAddress();
        if (inetAddress != null) {
            jSONObject.put((Object)"upnpExternalAddress", (Object)inetAddress.getHostAddress());
        }
        return jSONObject;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }
}

