/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Attachment;
import nxt.CurrencyType;
import nxt.NxtException;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public final class IssueCurrency
extends CreateTransaction {
    static final IssueCurrency instance = new IssueCurrency();

    private IssueCurrency() {
        super(new APITag[]{APITag.MS, APITag.CREATE_TRANSACTION}, "name", "code", "description", "type", "initialSupply", "reserveSupply", "maxSupply", "issuanceHeight", "minReservePerUnitNQT", "minDifficulty", "maxDifficulty", "ruleset", "algorithm", "decimals");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        int n;
        String string = Convert.nullToEmpty(httpServletRequest.getParameter("name"));
        String string2 = Convert.nullToEmpty(httpServletRequest.getParameter("code"));
        String string3 = Convert.nullToEmpty(httpServletRequest.getParameter("description"));
        if (string.length() < 3 || string.length() > 10) {
            return JSONResponses.INCORRECT_CURRENCY_NAME_LENGTH;
        }
        if (string2.length() < 3 || string2.length() > 5) {
            return JSONResponses.INCORRECT_CURRENCY_CODE_LENGTH;
        }
        if (string3.length() > 1000) {
            return JSONResponses.INCORRECT_CURRENCY_DESCRIPTION_LENGTH;
        }
        String string4 = string.toLowerCase(Locale.ROOT);
        for (n = 0; n < string4.length(); ++n) {
            if ("0123456789abcdefghijklmnopqrstuvwxyz".indexOf(string4.charAt(n)) >= 0) continue;
            return JSONResponses.INCORRECT_CURRENCY_NAME;
        }
        for (n = 0; n < string2.length(); ++n) {
            if ("ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(string2.charAt(n)) >= 0) continue;
            return JSONResponses.INCORRECT_CURRENCY_CODE;
        }
        n = 0;
        if (Convert.emptyToNull(httpServletRequest.getParameter("type")) == null) {
            for (CurrencyType currencyType : CurrencyType.values()) {
                if (!"1".equals(httpServletRequest.getParameter(currencyType.toString().toLowerCase(Locale.ROOT)))) continue;
                n |= currencyType.getCode();
            }
        } else {
            n = ParameterParser.getInt(httpServletRequest, "type", 0, Integer.MAX_VALUE, false);
        }
        long l = ParameterParser.getLong(httpServletRequest, "maxSupply", 1L, 100000000000000000L, false);
        long l2 = ParameterParser.getLong(httpServletRequest, "reserveSupply", 0L, l, false);
        long l3 = ParameterParser.getLong(httpServletRequest, "initialSupply", 0L, l, false);
        int n2 = ParameterParser.getInt(httpServletRequest, "issuanceHeight", 0, Integer.MAX_VALUE, false);
        long l4 = ParameterParser.getLong(httpServletRequest, "minReservePerUnitNQT", 1L, 100000000000000000L, false);
        int n3 = ParameterParser.getInt(httpServletRequest, "minDifficulty", 1, 255, false);
        int n4 = ParameterParser.getInt(httpServletRequest, "maxDifficulty", 1, 255, false);
        byte by = ParameterParser.getByte(httpServletRequest, "ruleset", (byte)0, (byte)127, false);
        byte by2 = ParameterParser.getByte(httpServletRequest, "algorithm", (byte)0, (byte)127, false);
        byte by3 = ParameterParser.getByte(httpServletRequest, "decimals", (byte)0, (byte)127, false);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        Attachment.MonetarySystemCurrencyIssuance monetarySystemCurrencyIssuance = new Attachment.MonetarySystemCurrencyIssuance(string, string2, string3, (byte)n, l3, l2, l, n2, l4, n3, n4, by, by2, by3);
        return this.createTransaction(httpServletRequest, account, monetarySystemCurrencyIssuance);
    }
}

