/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.math.BigInteger;
import javax.servlet.http.HttpServletRequest;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.util.Convert;
import nxt.util.JSON;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class LongConvert
extends APIServlet.APIRequestHandler {
    static final LongConvert instance = new LongConvert();

    private LongConvert() {
        super(new APITag[]{APITag.UTILS}, "id");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        String string = Convert.emptyToNull(httpServletRequest.getParameter("id"));
        if (string == null) {
            return JSON.emptyJSON;
        }
        JSONObject jSONObject = new JSONObject();
        BigInteger bigInteger = new BigInteger(string);
        if (bigInteger.signum() < 0) {
            if (bigInteger.negate().compareTo(Convert.two64) > 0) {
                return JSONResponses.OVERFLOW;
            }
            jSONObject.put((Object)"stringId", (Object)bigInteger.add(Convert.two64).toString());
            jSONObject.put((Object)"longId", (Object)String.valueOf(bigInteger.longValue()));
        } else {
            if (bigInteger.compareTo(Convert.two64) >= 0) {
                return JSONResponses.OVERFLOW;
            }
            jSONObject.put((Object)"stringId", (Object)bigInteger.toString());
            jSONObject.put((Object)"longId", (Object)String.valueOf(bigInteger.longValue()));
        }
        return jSONObject;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireBlockchain() {
        return false;
    }
}

