/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Attachment;
import nxt.Currency;
import nxt.NxtException;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONStreamAware;

public final class PublishExchangeOffer
extends CreateTransaction {
    static final PublishExchangeOffer instance = new PublishExchangeOffer();

    private PublishExchangeOffer() {
        super(new APITag[]{APITag.MS, APITag.CREATE_TRANSACTION}, "currency", "buyRateNQT", "sellRateNQT", "totalBuyLimit", "totalSellLimit", "initialBuySupply", "initialSellSupply", "expirationHeight");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Currency currency = ParameterParser.getCurrency(httpServletRequest);
        long l = ParameterParser.getLong(httpServletRequest, "buyRateNQT", 0L, Long.MAX_VALUE, true);
        long l2 = ParameterParser.getLong(httpServletRequest, "sellRateNQT", 0L, Long.MAX_VALUE, true);
        long l3 = ParameterParser.getLong(httpServletRequest, "totalBuyLimit", 0L, Long.MAX_VALUE, true);
        long l4 = ParameterParser.getLong(httpServletRequest, "totalSellLimit", 0L, Long.MAX_VALUE, true);
        long l5 = ParameterParser.getLong(httpServletRequest, "initialBuySupply", 0L, Long.MAX_VALUE, true);
        long l6 = ParameterParser.getLong(httpServletRequest, "initialSellSupply", 0L, Long.MAX_VALUE, true);
        int n = ParameterParser.getInt(httpServletRequest, "expirationHeight", 0, Integer.MAX_VALUE, true);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        Attachment.MonetarySystemPublishExchangeOffer monetarySystemPublishExchangeOffer = new Attachment.MonetarySystemPublishExchangeOffer(currency.getId(), l, l2, l3, l4, l5, l6, n);
        try {
            return this.createTransaction(httpServletRequest, account, monetarySystemPublishExchangeOffer);
        }
        catch (NxtException.InsufficientBalanceException insufficientBalanceException) {
            return JSONResponses.NOT_ENOUGH_FUNDS;
        }
    }
}

