/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Appendix;
import nxt.Nxt;
import nxt.PrunableMessage;
import nxt.Transaction;
import nxt.crypto.Crypto;
import nxt.crypto.EncryptedData;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import nxt.util.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class ReadMessage
extends APIServlet.APIRequestHandler {
    static final ReadMessage instance = new ReadMessage();

    private ReadMessage() {
        super(new APITag[]{APITag.MESSAGES}, "transaction", "secretPhrase", "sharedKey", "retrieve");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "transaction", true);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("retrieve"));
        Transaction transaction = Nxt.getBlockchain().getTransaction(l);
        if (transaction == null) {
            return JSONResponses.UNKNOWN_TRANSACTION;
        }
        PrunableMessage prunableMessage = PrunableMessage.getPrunableMessage(l);
        if (prunableMessage == null && (transaction.getPrunablePlainMessage() != null || transaction.getPrunableEncryptedMessage() != null) && bl) {
            if (Nxt.getBlockchainProcessor().restorePrunedTransaction(l) == null) {
                return JSONResponses.PRUNED_TRANSACTION;
            }
            prunableMessage = PrunableMessage.getPrunableMessage(l);
        }
        JSONObject jSONObject = new JSONObject();
        Appendix.Message message = transaction.getMessage();
        Appendix.EncryptedMessage encryptedMessage = transaction.getEncryptedMessage();
        Appendix.EncryptToSelfMessage encryptToSelfMessage = transaction.getEncryptToSelfMessage();
        if (message == null && encryptedMessage == null && encryptToSelfMessage == null && prunableMessage == null) {
            return JSONResponses.NO_MESSAGE;
        }
        if (message != null) {
            jSONObject.put((Object)"message", (Object)Convert.toString(message.getMessage(), message.isText()));
            jSONObject.put((Object)"messageIsPrunable", (Object)false);
        } else if (prunableMessage != null && prunableMessage.getMessage() != null) {
            jSONObject.put((Object)"message", (Object)Convert.toString(prunableMessage.getMessage(), prunableMessage.messageIsText()));
            jSONObject.put((Object)"messageIsPrunable", (Object)true);
        }
        String string = ParameterParser.getSecretPhrase(httpServletRequest, false);
        byte[] byArray = ParameterParser.getBytes(httpServletRequest, "sharedKey", false);
        if (byArray.length != 0 && string != null) {
            return JSONResponses.either("secretPhrase", "sharedKey");
        }
        if (string != null || byArray.length > 0) {
            byte[] byArray2;
            byte[] byArray3;
            EncryptedData encryptedData = null;
            boolean bl2 = false;
            boolean bl3 = true;
            if (encryptedMessage != null) {
                encryptedData = encryptedMessage.getEncryptedData();
                bl2 = encryptedMessage.isText();
                bl3 = encryptedMessage.isCompressed();
                jSONObject.put((Object)"encryptedMessageIsPrunable", (Object)false);
            } else if (prunableMessage != null && prunableMessage.getEncryptedData() != null) {
                encryptedData = prunableMessage.getEncryptedData();
                bl2 = prunableMessage.encryptedMessageIsText();
                bl3 = prunableMessage.isCompressed();
                jSONObject.put((Object)"encryptedMessageIsPrunable", (Object)true);
            }
            if (encryptedData != null) {
                try {
                    byArray3 = null;
                    if (string != null) {
                        byte[] byArray4;
                        byArray2 = Crypto.getPublicKey(string);
                        byte[] byArray5 = Account.getPublicKey(transaction.getSenderId());
                        byte[] byArray6 = Account.getPublicKey(transaction.getRecipientId());
                        byte[] byArray7 = byArray4 = Arrays.equals(byArray5, byArray2) ? byArray6 : byArray5;
                        if (byArray4 != null) {
                            byArray3 = Account.decryptFrom(byArray4, encryptedData, string, bl3);
                        }
                    } else {
                        byArray3 = Crypto.aesDecrypt(encryptedData.getData(), byArray);
                        if (bl3) {
                            byArray3 = Convert.uncompress(byArray3);
                        }
                    }
                    jSONObject.put((Object)"decryptedMessage", (Object)Convert.toString(byArray3, bl2));
                }
                catch (RuntimeException runtimeException) {
                    Logger.logDebugMessage("Decryption of message to recipient failed: " + runtimeException.toString());
                    JSONData.putException(jSONObject, runtimeException, "Wrong secretPhrase or sharedKey");
                }
            }
            if (encryptToSelfMessage != null && string != null) {
                byArray3 = Crypto.getPublicKey(string);
                try {
                    byArray2 = Account.decryptFrom(byArray3, encryptToSelfMessage.getEncryptedData(), string, encryptToSelfMessage.isCompressed());
                    jSONObject.put((Object)"decryptedMessageToSelf", (Object)Convert.toString(byArray2, encryptToSelfMessage.isText()));
                }
                catch (RuntimeException runtimeException) {
                    Logger.logDebugMessage("Decryption of message to self failed: " + runtimeException.toString());
                }
            }
        }
        return jSONObject;
    }
}

