/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Currency;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class SearchCurrencies
extends APIServlet.APIRequestHandler {
    static final SearchCurrencies instance = new SearchCurrencies();

    private SearchCurrencies() {
        super(new APITag[]{APITag.MS, APITag.SEARCH}, "query", "firstIndex", "lastIndex", "includeCounts");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        String string = Convert.nullToEmpty(httpServletRequest.getParameter("query"));
        if (string.isEmpty()) {
            return JSONResponses.missing("query");
        }
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeCounts"));
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        try (DbIterator<Currency> dbIterator = Currency.searchCurrencies(string, n, n2);){
            while (dbIterator.hasNext()) {
                jSONArray.add((Object)JSONData.currency(dbIterator.next(), bl));
            }
        }
        jSONObject.put((Object)"currencies", (Object)jSONArray);
        return jSONObject;
    }
}

