/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.http.APIProxy;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.peer.Peer;
import nxt.peer.PeerImpl;
import nxt.peer.Peers;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public class SetAPIProxyPeer
extends APIServlet.APIRequestHandler {
    static final SetAPIProxyPeer instance = new SetAPIProxyPeer();

    private SetAPIProxyPeer() {
        super(new APITag[]{APITag.NETWORK}, "peer");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        String string = Convert.emptyToNull(httpServletRequest.getParameter("peer"));
        if (string == null) {
            Peer peer = APIProxy.getInstance().setForcedPeer(null);
            if (peer == null) {
                return JSONResponses.API_PROXY_NO_OPEN_API_PEERS;
            }
            return JSONData.peer(peer);
        }
        PeerImpl peerImpl = Peers.findOrCreatePeer(string, false);
        if (peerImpl == null) {
            return JSONResponses.UNKNOWN_PEER;
        }
        if (peerImpl.getState() != Peer.State.CONNECTED) {
            return JSONResponses.PEER_NOT_CONNECTED;
        }
        if (!peerImpl.isOpenAPI()) {
            return JSONResponses.PEER_NOT_OPEN_API;
        }
        APIProxy.getInstance().setForcedPeer(peerImpl);
        return JSONData.peer(peerImpl);
    }

    @Override
    protected boolean requirePost() {
        return true;
    }

    @Override
    protected boolean requirePassword() {
        return true;
    }

    @Override
    protected boolean requireBlockchain() {
        return false;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }
}

