/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Asset;
import nxt.Attachment;
import nxt.NxtException;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public class SetAssetProperty
extends CreateTransaction {
    static final SetAssetProperty instance = new SetAssetProperty();

    private SetAssetProperty() {
        super(new APITag[]{APITag.AE, APITag.CREATE_TRANSACTION}, "asset", "property", "value");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        Asset asset = ParameterParser.getAsset(httpServletRequest);
        String string = Convert.nullToEmpty(httpServletRequest.getParameter("property")).trim();
        String string2 = Convert.nullToEmpty(httpServletRequest.getParameter("value")).trim();
        if (string.length() > 32 || string.length() == 0) {
            return JSONResponses.INCORRECT_ASSET_PROPERTY_NAME_LENGTH;
        }
        if (string2.length() > 160) {
            return JSONResponses.INCORRECT_ASSET_PROPERTY_VALUE_LENGTH;
        }
        Attachment.ColoredCoinsAssetProperty coloredCoinsAssetProperty = new Attachment.ColoredCoinsAssetProperty(asset.getId(), string, string2);
        return this.createTransaction(httpServletRequest, account, asset.getAccountId(), 0L, coloredCoinsAssetProperty);
    }
}

