/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Attachment;
import nxt.Constants;
import nxt.HoldingType;
import nxt.NxtException;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONStreamAware;

public final class ShufflingCreate
extends CreateTransaction {
    static final ShufflingCreate instance = new ShufflingCreate();

    private ShufflingCreate() {
        super(new APITag[]{APITag.SHUFFLING, APITag.CREATE_TRANSACTION}, "holding", "holdingType", "amount", "participantCount", "registrationPeriod");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        HoldingType holdingType = ParameterParser.getHoldingType(httpServletRequest);
        long l = ParameterParser.getHoldingId(httpServletRequest, holdingType);
        long l2 = ParameterParser.getLong(httpServletRequest, "amount", 0L, Long.MAX_VALUE, true);
        if (holdingType == HoldingType.NXT && l2 < Constants.SHUFFLING_DEPOSIT_NQT) {
            return JSONResponses.incorrect("amount", "Minimum shuffling amount is " + Constants.SHUFFLING_DEPOSIT_NQT / 100000000L + " NXT");
        }
        byte by = ParameterParser.getByte(httpServletRequest, "participantCount", (byte)3, (byte)30, true);
        short s = (short)ParameterParser.getInt(httpServletRequest, "registrationPeriod", 0, 10080, true);
        Attachment.ShufflingCreation shufflingCreation = new Attachment.ShufflingCreation(l, holdingType, l2, by, s);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        if (account.getControls().contains((Object)Account.ControlType.PHASING_ONLY)) {
            return JSONResponses.error("Accounts under phasing only control cannot start a shuffling");
        }
        try {
            return this.createTransaction(httpServletRequest, account, shufflingCreation);
        }
        catch (NxtException.InsufficientBalanceException insufficientBalanceException) {
            return JSONResponses.notEnoughHolding(holdingType);
        }
    }
}

