/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Attachment;
import nxt.NxtException;
import nxt.Shuffling;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONStreamAware;

public final class ShufflingRegister
extends CreateTransaction {
    static final ShufflingRegister instance = new ShufflingRegister();

    private ShufflingRegister() {
        super(new APITag[]{APITag.SHUFFLING, APITag.CREATE_TRANSACTION}, "shufflingFullHash");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        byte[] byArray = ParameterParser.getBytes(httpServletRequest, "shufflingFullHash", true);
        Attachment.ShufflingRegistration shufflingRegistration = new Attachment.ShufflingRegistration(byArray);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        if (account.getControls().contains((Object)Account.ControlType.PHASING_ONLY)) {
            return JSONResponses.error("Accounts under phasing only control cannot join a shuffling");
        }
        try {
            return this.createTransaction(httpServletRequest, account, shufflingRegistration);
        }
        catch (NxtException.InsufficientBalanceException insufficientBalanceException) {
            Shuffling shuffling = Shuffling.getShuffling(byArray);
            if (shuffling == null) {
                return JSONResponses.NOT_ENOUGH_FUNDS;
            }
            return JSONResponses.notEnoughHolding(shuffling.getHoldingType());
        }
    }
}

