/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Asset;
import nxt.Attachment;
import nxt.NxtException;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONStreamAware;

public final class TransferAsset
extends CreateTransaction {
    static final TransferAsset instance = new TransferAsset();

    private TransferAsset() {
        super(new APITag[]{APITag.AE, APITag.CREATE_TRANSACTION}, "recipient", "asset", "quantityQNT");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getAccountId(httpServletRequest, "recipient", true);
        Asset asset = ParameterParser.getAsset(httpServletRequest);
        long l2 = ParameterParser.getQuantityQNT(httpServletRequest);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        Attachment.ColoredCoinsAssetTransfer coloredCoinsAssetTransfer = new Attachment.ColoredCoinsAssetTransfer(asset.getId(), l2);
        try {
            return this.createTransaction(httpServletRequest, account, l, 0L, coloredCoinsAssetTransfer);
        }
        catch (NxtException.InsufficientBalanceException insufficientBalanceException) {
            return JSONResponses.NOT_ENOUGH_ASSETS;
        }
    }
}

