/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import nxt.Appendix;
import nxt.Nxt;
import nxt.NxtException;
import nxt.Transaction;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.JSON;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class VerifyPrunableMessage
extends APIServlet.APIRequestHandler {
    static final VerifyPrunableMessage instance = new VerifyPrunableMessage();
    private static final JSONStreamAware NO_SUCH_PLAIN_MESSAGE;
    private static final JSONStreamAware NO_SUCH_ENCRYPTED_MESSAGE;

    private VerifyPrunableMessage() {
        super(new APITag[]{APITag.MESSAGES}, "transaction", "message", "messageIsText", "messageToEncryptIsText", "encryptedMessageData", "encryptedMessageNonce", "compressMessageToEncrypt");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "transaction", true);
        Transaction transaction = Nxt.getBlockchain().getTransaction(l);
        if (transaction == null) {
            return JSONResponses.UNKNOWN_TRANSACTION;
        }
        Appendix.PrunablePlainMessage prunablePlainMessage = (Appendix.PrunablePlainMessage)ParameterParser.getPlainMessage(httpServletRequest, true);
        Appendix.PrunableEncryptedMessage prunableEncryptedMessage = (Appendix.PrunableEncryptedMessage)ParameterParser.getEncryptedMessage(httpServletRequest, null, true);
        if (prunablePlainMessage == null && prunableEncryptedMessage == null) {
            return JSONResponses.MISSING_MESSAGE_ENCRYPTED_MESSAGE;
        }
        if (prunablePlainMessage != null && prunableEncryptedMessage != null) {
            return JSONResponses.EITHER_MESSAGE_ENCRYPTED_MESSAGE;
        }
        if (prunablePlainMessage != null) {
            Appendix.PrunablePlainMessage prunablePlainMessage2 = transaction.getPrunablePlainMessage();
            if (prunablePlainMessage2 == null) {
                return NO_SUCH_PLAIN_MESSAGE;
            }
            if (!Arrays.equals(prunablePlainMessage2.getHash(), prunablePlainMessage.getHash())) {
                return JSONResponses.HASHES_MISMATCH;
            }
            JSONObject jSONObject = prunablePlainMessage2.getJSONObject();
            jSONObject.put((Object)"verify", (Object)true);
            return jSONObject;
        }
        if (prunableEncryptedMessage != null) {
            Appendix.PrunableEncryptedMessage prunableEncryptedMessage2 = transaction.getPrunableEncryptedMessage();
            if (prunableEncryptedMessage2 == null) {
                return NO_SUCH_ENCRYPTED_MESSAGE;
            }
            if (!Arrays.equals(prunableEncryptedMessage2.getHash(), prunableEncryptedMessage.getHash())) {
                return JSONResponses.HASHES_MISMATCH;
            }
            JSONObject jSONObject = prunableEncryptedMessage2.getJSONObject();
            jSONObject.put((Object)"verify", (Object)true);
            return jSONObject;
        }
        return JSON.emptyJSON;
    }

    static {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"errorCode", (Object)5);
        jSONObject.put((Object)"errorDescription", (Object)"This transaction has no plain message attachment");
        NO_SUCH_PLAIN_MESSAGE = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put((Object)"errorCode", (Object)5);
        jSONObject.put((Object)"errorDescription", (Object)"This transaction has no encrypted message attachment");
        NO_SUCH_ENCRYPTED_MESSAGE = JSON.prepare(jSONObject);
    }
}

