/*
 * Decompiled with CFR 0.152.
 */
package nxt.tools;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import nxt.Constants;
import nxt.util.Convert;
import nxt.util.Logger;

public final class BaseTargetTest {
    private static final long MIN_BASE_TARGET = 138350580L;
    private static final long MAX_BASE_TARGET = Constants.isTestnet ? 153722867000000000L : 7686143350L;
    private static final int MIN_BLOCKTIME_LIMIT = 53;
    private static final int MAX_BLOCKTIME_LIMIT = 67;
    private static final int GAMMA = 64;
    private static final int START_HEIGHT = 170000;
    private static final boolean USE_EWMA = false;
    private static final int EWMA_N = 8;
    private static final int SMA_N = 3;
    private static final int FREQUENCY = 2;

    private static long calculateBaseTarget(long l, long l2) {
        long l3 = l2 > 60L ? l * Math.min(l2, 67L) / 60L : l - l * 64L * (60L - Math.max(l2, 53L)) / 6000L;
        if (l3 < 0L || l3 > MAX_BASE_TARGET) {
            l3 = MAX_BASE_TARGET;
        }
        if (l3 < 138350580L) {
            l3 = 138350580L;
        }
        return l3;
    }

    public static void main(String[] stringArray) {
        try {
            BigInteger bigInteger = BigInteger.ZERO;
            BigInteger bigInteger2 = BigInteger.ZERO;
            BigInteger bigInteger3 = null;
            long l = 0L;
            int n = 0;
            BigInteger bigInteger4 = null;
            long l2 = 0L;
            int n2 = 0;
            int n3 = 170000;
            if (stringArray.length == 1) {
                n3 = Integer.parseInt(stringArray[0]);
            }
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            long l6 = Integer.MAX_VALUE;
            long l7 = 0L;
            long l8 = Integer.MAX_VALUE;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            long l9 = 0L;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n4 = 0;
            String string = Constants.isTestnet ? "nxt_test_db" : "nxt_db";
            try (Connection connection = DriverManager.getConnection("jdbc:h2:./" + string + "/nxt;DB_CLOSE_ON_EXIT=FALSE", "sa", "sa");
                 PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM block WHERE height > " + n3 + " ORDER BY db_id ASC");
                 ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    bigInteger2 = new BigInteger(resultSet.getBytes("cumulative_difficulty"));
                    long l10 = resultSet.getLong("base_target");
                    int n5 = resultSet.getInt("timestamp");
                    n3 = resultSet.getInt("height");
                    if (bigInteger3 == null) {
                        bigInteger3 = bigInteger2;
                        l = l10;
                        n = n5;
                        bigInteger4 = bigInteger3;
                        l2 = l;
                        n2 = n;
                        continue;
                    }
                    int n6 = (int)(l * (long)(n5 - n - 1) / l2) + 1;
                    l9 = l9 == 0L ? (long)n6 : ((long)n6 + l9 * 7L) / 8L;
                    int n7 = n2 + n6;
                    arrayList.add(n6);
                    if (arrayList.size() > 3) {
                        arrayList.remove(0);
                    }
                    int n8 = 0;
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        int n9 = (Integer)iterator.next();
                        n8 += n9;
                    }
                    long l11 = arrayList.size() < 3 ? l10 : ((n3 - 1) % 2 == 0 ? BaseTargetTest.calculateBaseTarget(l2, n8 /= arrayList.size()) : l2);
                    bigInteger = bigInteger4.add(Convert.two64.divide(BigInteger.valueOf(l11)));
                    int n10 = n5 - n;
                    if ((long)n10 > l5) {
                        l5 = n10;
                    }
                    if ((long)n10 < l6) {
                        l6 = n10;
                    }
                    if ((long)n6 > l7) {
                        l7 = n6;
                    }
                    if ((long)n6 < l8) {
                        l8 = n6;
                    }
                    l3 += (long)n10;
                    l4 += (long)n6;
                    double d5 = d;
                    d2 += ((double)n10 - d5) * ((double)n10 - (d += ((double)n10 - d5) / (double)(++n4)));
                    d5 = d3;
                    d4 += ((double)n6 - d5) * ((double)n6 - (d3 += ((double)n6 - d5) / (double)n4));
                    n2 = n7;
                    l2 = l11;
                    bigInteger4 = bigInteger;
                    n = n5;
                    l = l10;
                    bigInteger3 = bigInteger2;
                }
            }
            Logger.logMessage("Cumulative difficulty " + bigInteger2.toString());
            Logger.logMessage("Test cumulative difficulty " + bigInteger.toString());
            Logger.logMessage("Cumulative difficulty difference " + bigInteger.subtract(bigInteger2).multiply(BigInteger.valueOf(100L)).divide(bigInteger2).toString());
            Logger.logMessage("Max blocktime " + l5);
            Logger.logMessage("Max test blocktime " + l7);
            Logger.logMessage("Min blocktime " + l6);
            Logger.logMessage("Min test blocktime " + l8);
            Logger.logMessage("Average blocktime " + (double)l3 / (double)n4);
            Logger.logMessage("Average test blocktime " + (double)l4 / (double)n4);
            Logger.logMessage("Standard deviation of blocktime " + Math.sqrt(d2 / (double)n4));
            Logger.logMessage("Standard deviation of test blocktime " + Math.sqrt(d4 / (double)n4));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

