/*
 * Decompiled with CFR 0.152.
 */
package nxt.user;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import nxt.Account;
import nxt.Block;
import nxt.BlockchainProcessor;
import nxt.Constants;
import nxt.Generator;
import nxt.Nxt;
import nxt.Transaction;
import nxt.TransactionProcessor;
import nxt.peer.Peer;
import nxt.peer.Peers;
import nxt.user.User;
import nxt.user.UserServlet;
import nxt.util.Convert;
import nxt.util.Logger;
import nxt.util.ThreadPool;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class Users {
    private static final int TESTNET_UI_PORT = 2875;
    private static final ConcurrentMap<String, User> users = new ConcurrentHashMap<String, User>();
    private static final Collection<User> allUsers = Collections.unmodifiableCollection(users.values());
    private static final AtomicInteger peerCounter = new AtomicInteger();
    private static final ConcurrentMap<String, Integer> peerIndexMap = new ConcurrentHashMap<String, Integer>();
    private static final ConcurrentMap<Integer, String> peerAddressMap = new ConcurrentHashMap<Integer, String>();
    private static final AtomicInteger blockCounter = new AtomicInteger();
    private static final ConcurrentMap<Long, Integer> blockIndexMap = new ConcurrentHashMap<Long, Integer>();
    private static final AtomicInteger transactionCounter = new AtomicInteger();
    private static final ConcurrentMap<Long, Integer> transactionIndexMap = new ConcurrentHashMap<Long, Integer>();
    static final Set<String> allowedUserHosts;
    private static final Server userServer;

    static Collection<User> getAllUsers() {
        return allUsers;
    }

    static User getUser(String string) {
        User user = (User)users.get(string);
        if (user == null) {
            user = new User(string);
            User user2 = users.putIfAbsent(string, user);
            if (user2 != null) {
                user = user2;
                user.setInactive(false);
            }
        } else {
            user.setInactive(false);
        }
        return user;
    }

    static User remove(User user) {
        return (User)users.remove(user.getUserId());
    }

    private static void sendNewDataToAll(JSONObject jSONObject) {
        jSONObject.put((Object)"response", (Object)"processNewData");
        Users.sendToAll((JSONStreamAware)jSONObject);
    }

    private static void sendToAll(JSONStreamAware jSONStreamAware) {
        for (User user : users.values()) {
            user.send(jSONStreamAware);
        }
    }

    static int getIndex(Peer peer) {
        Integer n = (Integer)peerIndexMap.get(peer.getHost());
        if (n == null) {
            n = peerCounter.incrementAndGet();
            peerIndexMap.put(peer.getHost(), n);
            peerAddressMap.put(n, peer.getHost());
        }
        return n;
    }

    static Peer getPeer(int n) {
        String string = (String)peerAddressMap.get(n);
        if (string == null) {
            return null;
        }
        return Peers.getPeer(string);
    }

    static int getIndex(Block block) {
        Integer n = (Integer)blockIndexMap.get(block.getId());
        if (n == null) {
            n = blockCounter.incrementAndGet();
            blockIndexMap.put(block.getId(), n);
        }
        return n;
    }

    static int getIndex(Transaction transaction) {
        Integer n = (Integer)transactionIndexMap.get(transaction.getId());
        if (n == null) {
            n = transactionCounter.incrementAndGet();
            transactionIndexMap.put(transaction.getId(), n);
        }
        return n;
    }

    public static void init() {
    }

    public static void shutdown() {
        if (userServer != null) {
            try {
                userServer.stop();
            }
            catch (Exception exception) {
                Logger.logShutdownMessage("Failed to stop user interface server", exception);
            }
        }
    }

    private Users() {
    }

    static {
        List<String> list2 = Nxt.getStringListProperty("nxt.allowedUserHosts");
        allowedUserHosts = !list2.contains("*") ? Collections.unmodifiableSet(new HashSet<String>(list2)) : null;
        boolean bl = Nxt.getBooleanProperty("nxt.enableUIServer");
        if (bl) {
            ResourceHandler resourceHandler;
            ServletHandler servletHandler;
            ServerConnector serverConnector;
            SslContextFactory sslContextFactory;
            HttpConfiguration httpConfiguration;
            int n = Constants.isTestnet ? 2875 : Nxt.getIntProperty("nxt.uiServerPort");
            String string = Nxt.getStringProperty("nxt.uiServerHost");
            userServer = new Server();
            boolean bl2 = Nxt.getBooleanProperty("nxt.uiSSL");
            if (bl2) {
                Logger.logMessage("Using SSL (https) for the user interface server");
                httpConfiguration = new HttpConfiguration();
                httpConfiguration.setSecureScheme("https");
                httpConfiguration.setSecurePort(n);
                httpConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                sslContextFactory = new SslContextFactory();
                sslContextFactory.setKeyStorePath(Nxt.getStringProperty("nxt.keyStorePath"));
                sslContextFactory.setKeyStorePassword(Nxt.getStringProperty("nxt.keyStorePassword", null, true));
                sslContextFactory.addExcludeCipherSuites(new String[]{"SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"});
                sslContextFactory.addExcludeProtocols(new String[]{"SSLv3"});
                serverConnector = new ServerConnector(userServer, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(httpConfiguration)});
            } else {
                serverConnector = new ServerConnector(userServer);
            }
            serverConnector.setPort(n);
            serverConnector.setHost(string);
            serverConnector.setIdleTimeout((long)Nxt.getIntProperty("nxt.uiServerIdleTimeout"));
            serverConnector.setReuseAddress(true);
            userServer.addConnector((Connector)serverConnector);
            httpConfiguration = new HandlerList();
            sslContextFactory = new ResourceHandler();
            sslContextFactory.setDirectoriesListed(false);
            sslContextFactory.setWelcomeFiles(new String[]{"index.html"});
            sslContextFactory.setResourceBase(Nxt.getStringProperty("nxt.uiResourceBase"));
            httpConfiguration.addHandler((Handler)sslContextFactory);
            String string2 = Nxt.getStringProperty("nxt.javadocResourceBase");
            if (string2 != null) {
                servletHandler = new ContextHandler("/doc");
                resourceHandler = new ResourceHandler();
                resourceHandler.setDirectoriesListed(false);
                resourceHandler.setWelcomeFiles(new String[]{"index.html"});
                resourceHandler.setResourceBase(string2);
                servletHandler.setHandler((Handler)resourceHandler);
                httpConfiguration.addHandler((Handler)servletHandler);
            }
            servletHandler = new ServletHandler();
            resourceHandler = servletHandler.addServletWithMapping(UserServlet.class, "/nxt");
            resourceHandler.setAsyncSupported(true);
            if (Nxt.getBooleanProperty("nxt.uiServerCORS")) {
                FilterHolder filterHolder = servletHandler.addFilterWithMapping(CrossOriginFilter.class, "/*", 0);
                filterHolder.setInitParameter("allowedHeaders", "*");
                filterHolder.setAsyncSupported(true);
            }
            httpConfiguration.addHandler((Handler)servletHandler);
            httpConfiguration.addHandler((Handler)new DefaultHandler());
            userServer.setHandler((Handler)httpConfiguration);
            userServer.setStopAtShutdown(true);
            ThreadPool.runBeforeStart(() -> {
                try {
                    userServer.start();
                    Logger.logMessage("Started user interface server at " + string + ":" + n);
                }
                catch (Exception exception) {
                    Logger.logErrorMessage("Failed to start user interface server", exception);
                    throw new RuntimeException(exception.toString(), exception);
                }
            }, true);
        } else {
            userServer = null;
            Logger.logMessage("User interface server not enabled");
        }
        if (userServer != null) {
            Account.addListener(account -> {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put((Object)"response", (Object)"setBalance");
                jSONObject.put((Object)"balanceNQT", (Object)account.getUnconfirmedBalanceNQT());
                byte[] byArray = Account.getPublicKey(account.getId());
                users.values().forEach(user -> {
                    if (user.getSecretPhrase() != null && Arrays.equals(user.getPublicKey(), byArray)) {
                        user.send((JSONStreamAware)jSONObject);
                    }
                });
            }, Account.Event.UNCONFIRMED_BALANCE);
            Peers.addListener(peer -> {
                JSONObject jSONObject = new JSONObject();
                JSONArray jSONArray = new JSONArray();
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put((Object)"index", (Object)Users.getIndex(peer));
                jSONArray.add((Object)jSONObject2);
                jSONObject.put((Object)"removedActivePeers", (Object)jSONArray);
                JSONArray jSONArray2 = new JSONArray();
                JSONObject jSONObject3 = new JSONObject();
                jSONObject3.put((Object)"index", (Object)Users.getIndex(peer));
                jSONArray2.add((Object)jSONObject3);
                jSONObject.put((Object)"removedKnownPeers", (Object)jSONArray2);
                JSONArray jSONArray3 = new JSONArray();
                JSONObject jSONObject4 = new JSONObject();
                jSONObject4.put((Object)"index", (Object)Users.getIndex(peer));
                jSONObject4.put((Object)"address", (Object)peer.getHost());
                jSONObject4.put((Object)"announcedAddress", (Object)Convert.truncate(peer.getAnnouncedAddress(), "-", 25, true));
                jSONObject4.put((Object)"software", (Object)peer.getSoftware());
                jSONArray3.add((Object)jSONObject4);
                jSONObject.put((Object)"addedBlacklistedPeers", (Object)jSONArray3);
                Users.sendNewDataToAll(jSONObject);
            }, Peers.Event.BLACKLIST);
            Peers.addListener(peer -> {
                JSONObject jSONObject = new JSONObject();
                JSONArray jSONArray = new JSONArray();
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put((Object)"index", (Object)Users.getIndex(peer));
                jSONArray.add((Object)jSONObject2);
                jSONObject.put((Object)"removedActivePeers", (Object)jSONArray);
                JSONArray jSONArray2 = new JSONArray();
                JSONObject jSONObject3 = new JSONObject();
                jSONObject3.put((Object)"index", (Object)Users.getIndex(peer));
                jSONObject3.put((Object)"address", (Object)peer.getHost());
                jSONObject3.put((Object)"announcedAddress", (Object)Convert.truncate(peer.getAnnouncedAddress(), "-", 25, true));
                jSONObject3.put((Object)"software", (Object)peer.getSoftware());
                jSONArray2.add((Object)jSONObject3);
                jSONObject.put((Object)"addedKnownPeers", (Object)jSONArray2);
                Users.sendNewDataToAll(jSONObject);
            }, Peers.Event.DEACTIVATE);
            Peers.addListener(peer -> {
                JSONObject jSONObject = new JSONObject();
                JSONArray jSONArray = new JSONArray();
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put((Object)"index", (Object)Users.getIndex(peer));
                jSONArray.add((Object)jSONObject2);
                jSONObject.put((Object)"removedBlacklistedPeers", (Object)jSONArray);
                JSONArray jSONArray2 = new JSONArray();
                JSONObject jSONObject3 = new JSONObject();
                jSONObject3.put((Object)"index", (Object)Users.getIndex(peer));
                jSONObject3.put((Object)"address", (Object)peer.getHost());
                jSONObject3.put((Object)"announcedAddress", (Object)Convert.truncate(peer.getAnnouncedAddress(), "-", 25, true));
                jSONObject3.put((Object)"software", (Object)peer.getSoftware());
                jSONArray2.add((Object)jSONObject3);
                jSONObject.put((Object)"addedKnownPeers", (Object)jSONArray2);
                Users.sendNewDataToAll(jSONObject);
            }, Peers.Event.UNBLACKLIST);
            Peers.addListener(peer -> {
                JSONObject jSONObject = new JSONObject();
                JSONArray jSONArray = new JSONArray();
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put((Object)"index", (Object)Users.getIndex(peer));
                jSONArray.add((Object)jSONObject2);
                jSONObject.put((Object)"removedKnownPeers", (Object)jSONArray);
                Users.sendNewDataToAll(jSONObject);
            }, Peers.Event.REMOVE);
            Peers.addListener(peer -> {
                JSONObject jSONObject = new JSONObject();
                JSONArray jSONArray = new JSONArray();
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put((Object)"index", (Object)Users.getIndex(peer));
                jSONObject2.put((Object)"downloaded", (Object)peer.getDownloadedVolume());
                jSONArray.add((Object)jSONObject2);
                jSONObject.put((Object)"changedActivePeers", (Object)jSONArray);
                Users.sendNewDataToAll(jSONObject);
            }, Peers.Event.DOWNLOADED_VOLUME);
            Peers.addListener(peer -> {
                JSONObject jSONObject = new JSONObject();
                JSONArray jSONArray = new JSONArray();
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put((Object)"index", (Object)Users.getIndex(peer));
                jSONObject2.put((Object)"uploaded", (Object)peer.getUploadedVolume());
                jSONArray.add((Object)jSONObject2);
                jSONObject.put((Object)"changedActivePeers", (Object)jSONArray);
                Users.sendNewDataToAll(jSONObject);
            }, Peers.Event.UPLOADED_VOLUME);
            Peers.addListener(peer -> {
                JSONObject jSONObject = new JSONObject();
                JSONArray jSONArray = new JSONArray();
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put((Object)"index", (Object)Users.getIndex(peer));
                jSONObject2.put((Object)"weight", (Object)peer.getWeight());
                jSONArray.add((Object)jSONObject2);
                jSONObject.put((Object)"changedActivePeers", (Object)jSONArray);
                Users.sendNewDataToAll(jSONObject);
            }, Peers.Event.WEIGHT);
            Peers.addListener(peer -> {
                JSONObject jSONObject = new JSONObject();
                JSONArray jSONArray = new JSONArray();
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put((Object)"index", (Object)Users.getIndex(peer));
                jSONArray.add((Object)jSONObject2);
                jSONObject.put((Object)"removedKnownPeers", (Object)jSONArray);
                JSONArray jSONArray2 = new JSONArray();
                JSONObject jSONObject3 = new JSONObject();
                jSONObject3.put((Object)"index", (Object)Users.getIndex(peer));
                if (peer.getState() != Peer.State.CONNECTED) {
                    jSONObject3.put((Object)"disconnected", (Object)true);
                }
                jSONObject3.put((Object)"address", (Object)peer.getHost());
                jSONObject3.put((Object)"announcedAddress", (Object)Convert.truncate(peer.getAnnouncedAddress(), "-", 25, true));
                jSONObject3.put((Object)"weight", (Object)peer.getWeight());
                jSONObject3.put((Object)"downloaded", (Object)peer.getDownloadedVolume());
                jSONObject3.put((Object)"uploaded", (Object)peer.getUploadedVolume());
                jSONObject3.put((Object)"software", (Object)peer.getSoftware());
                jSONArray2.add((Object)jSONObject3);
                jSONObject.put((Object)"addedActivePeers", (Object)jSONArray2);
                Users.sendNewDataToAll(jSONObject);
            }, Peers.Event.ADDED_ACTIVE_PEER);
            Peers.addListener(peer -> {
                JSONObject jSONObject = new JSONObject();
                JSONArray jSONArray = new JSONArray();
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put((Object)"index", (Object)Users.getIndex(peer));
                jSONObject2.put((Object)(peer.getState() == Peer.State.CONNECTED ? "connected" : "disconnected"), (Object)true);
                jSONObject2.put((Object)"announcedAddress", (Object)Convert.truncate(peer.getAnnouncedAddress(), "-", 25, true));
                jSONArray.add((Object)jSONObject2);
                jSONObject.put((Object)"changedActivePeers", (Object)jSONArray);
                Users.sendNewDataToAll(jSONObject);
            }, Peers.Event.CHANGED_ACTIVE_PEER);
            Peers.addListener(peer -> {
                JSONObject jSONObject = new JSONObject();
                JSONArray jSONArray = new JSONArray();
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put((Object)"index", (Object)Users.getIndex(peer));
                jSONObject2.put((Object)"address", (Object)peer.getHost());
                jSONObject2.put((Object)"announcedAddress", (Object)Convert.truncate(peer.getAnnouncedAddress(), "-", 25, true));
                jSONObject2.put((Object)"software", (Object)peer.getSoftware());
                jSONArray.add((Object)jSONObject2);
                jSONObject.put((Object)"addedKnownPeers", (Object)jSONArray);
                Users.sendNewDataToAll(jSONObject);
            }, Peers.Event.NEW_PEER);
            Nxt.getTransactionProcessor().addListener(list -> {
                JSONObject jSONObject = new JSONObject();
                JSONArray jSONArray = new JSONArray();
                for (Transaction transaction : list) {
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put((Object)"index", (Object)Users.getIndex(transaction));
                    jSONArray.add((Object)jSONObject2);
                }
                jSONObject.put((Object)"removedUnconfirmedTransactions", (Object)jSONArray);
                Users.sendNewDataToAll(jSONObject);
            }, TransactionProcessor.Event.REMOVED_UNCONFIRMED_TRANSACTIONS);
            Nxt.getTransactionProcessor().addListener(list -> {
                JSONObject jSONObject = new JSONObject();
                JSONArray jSONArray = new JSONArray();
                for (Transaction transaction : list) {
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put((Object)"index", (Object)Users.getIndex(transaction));
                    jSONObject2.put((Object)"timestamp", (Object)transaction.getTimestamp());
                    jSONObject2.put((Object)"deadline", (Object)transaction.getDeadline());
                    jSONObject2.put((Object)"recipient", (Object)Long.toUnsignedString(transaction.getRecipientId()));
                    jSONObject2.put((Object)"amountNQT", (Object)transaction.getAmountNQT());
                    jSONObject2.put((Object)"feeNQT", (Object)transaction.getFeeNQT());
                    jSONObject2.put((Object)"sender", (Object)Long.toUnsignedString(transaction.getSenderId()));
                    jSONObject2.put((Object)"id", (Object)transaction.getStringId());
                    jSONArray.add((Object)jSONObject2);
                }
                jSONObject.put((Object)"addedUnconfirmedTransactions", (Object)jSONArray);
                Users.sendNewDataToAll(jSONObject);
            }, TransactionProcessor.Event.ADDED_UNCONFIRMED_TRANSACTIONS);
            Nxt.getTransactionProcessor().addListener(list -> {
                JSONObject jSONObject = new JSONObject();
                JSONArray jSONArray = new JSONArray();
                for (Transaction transaction : list) {
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put((Object)"index", (Object)Users.getIndex(transaction));
                    jSONObject2.put((Object)"blockTimestamp", (Object)transaction.getBlockTimestamp());
                    jSONObject2.put((Object)"transactionTimestamp", (Object)transaction.getTimestamp());
                    jSONObject2.put((Object)"sender", (Object)Long.toUnsignedString(transaction.getSenderId()));
                    jSONObject2.put((Object)"recipient", (Object)Long.toUnsignedString(transaction.getRecipientId()));
                    jSONObject2.put((Object)"amountNQT", (Object)transaction.getAmountNQT());
                    jSONObject2.put((Object)"feeNQT", (Object)transaction.getFeeNQT());
                    jSONObject2.put((Object)"id", (Object)transaction.getStringId());
                    jSONArray.add((Object)jSONObject2);
                }
                jSONObject.put((Object)"addedConfirmedTransactions", (Object)jSONArray);
                Users.sendNewDataToAll(jSONObject);
            }, TransactionProcessor.Event.ADDED_CONFIRMED_TRANSACTIONS);
            Nxt.getBlockchainProcessor().addListener(block -> {
                JSONObject jSONObject = new JSONObject();
                JSONArray jSONArray = new JSONArray();
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put((Object)"index", (Object)Users.getIndex(block));
                jSONObject2.put((Object)"timestamp", (Object)block.getTimestamp());
                jSONObject2.put((Object)"numberOfTransactions", (Object)block.getTransactions().size());
                jSONObject2.put((Object)"totalAmountNQT", (Object)block.getTotalAmountNQT());
                jSONObject2.put((Object)"totalFeeNQT", (Object)block.getTotalFeeNQT());
                jSONObject2.put((Object)"payloadLength", (Object)block.getPayloadLength());
                jSONObject2.put((Object)"generator", (Object)Long.toUnsignedString(block.getGeneratorId()));
                jSONObject2.put((Object)"height", (Object)block.getHeight());
                jSONObject2.put((Object)"version", (Object)block.getVersion());
                jSONObject2.put((Object)"block", (Object)block.getStringId());
                jSONObject2.put((Object)"baseTarget", (Object)BigInteger.valueOf(block.getBaseTarget()).multiply(BigInteger.valueOf(100000L)).divide(BigInteger.valueOf(153722867L)));
                jSONArray.add((Object)jSONObject2);
                jSONObject.put((Object)"addedOrphanedBlocks", (Object)jSONArray);
                Users.sendNewDataToAll(jSONObject);
            }, BlockchainProcessor.Event.BLOCK_POPPED);
            Nxt.getBlockchainProcessor().addListener(block -> {
                JSONObject jSONObject = new JSONObject();
                JSONArray jSONArray = new JSONArray();
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put((Object)"index", (Object)Users.getIndex(block));
                jSONObject2.put((Object)"timestamp", (Object)block.getTimestamp());
                jSONObject2.put((Object)"numberOfTransactions", (Object)block.getTransactions().size());
                jSONObject2.put((Object)"totalAmountNQT", (Object)block.getTotalAmountNQT());
                jSONObject2.put((Object)"totalFeeNQT", (Object)block.getTotalFeeNQT());
                jSONObject2.put((Object)"payloadLength", (Object)block.getPayloadLength());
                jSONObject2.put((Object)"generator", (Object)Long.toUnsignedString(block.getGeneratorId()));
                jSONObject2.put((Object)"height", (Object)block.getHeight());
                jSONObject2.put((Object)"version", (Object)block.getVersion());
                jSONObject2.put((Object)"block", (Object)block.getStringId());
                jSONObject2.put((Object)"baseTarget", (Object)BigInteger.valueOf(block.getBaseTarget()).multiply(BigInteger.valueOf(100000L)).divide(BigInteger.valueOf(153722867L)));
                jSONArray.add((Object)jSONObject2);
                jSONObject.put((Object)"addedRecentBlocks", (Object)jSONArray);
                Users.sendNewDataToAll(jSONObject);
            }, BlockchainProcessor.Event.BLOCK_PUSHED);
            Generator.addListener(generator -> {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put((Object)"response", (Object)"setBlockGenerationDeadline");
                jSONObject.put((Object)"deadline", (Object)generator.getDeadline());
                users.values().forEach(user -> {
                    if (Arrays.equals(generator.getPublicKey(), user.getPublicKey())) {
                        user.send((JSONStreamAware)jSONObject);
                    }
                });
            }, Generator.Event.GENERATION_DEADLINE);
        }
    }
}

