/*
 * Decompiled with CFR 0.152.
 */
package nxt.util;

import java.io.IOException;
import java.util.ArrayList;
import nxt.Constants;
import nxt.util.Convert;
import nxt.util.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.tika.Tika;

public final class Search {
    private static final Analyzer analyzer = new StandardAnalyzer();

    public static String[] parseTags(String string, int n, int n2, int n3) {
        if (string.trim().length() == 0) {
            return Convert.EMPTY_STRING;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try (TokenStream tokenStream = analyzer.tokenStream(null, string);){
            String string2;
            CharTermAttribute charTermAttribute = (CharTermAttribute)tokenStream.addAttribute(CharTermAttribute.class);
            tokenStream.reset();
            while (tokenStream.incrementToken() && arrayList.size() < n3 && (string2 = charTermAttribute.toString()).length() <= n2 && string2.length() >= n) {
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
            tokenStream.end();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString(), iOException);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String detectMimeType(byte[] byArray, String string) {
        if (Constants.DISABLE_METADATA_DETECTION) {
            throw new UnsupportedOperationException("Metadata detection is disabled");
        }
        Tika tika = new Tika();
        return tika.detect(byArray, string);
    }

    public static String detectMimeType(byte[] byArray) {
        if (Constants.DISABLE_METADATA_DETECTION) {
            throw new UnsupportedOperationException("Metadata detection is disabled");
        }
        Tika tika = new Tika();
        try {
            return tika.detect(byArray);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Logger.logErrorMessage("Error running Tika parsers", noClassDefFoundError);
            return null;
        }
    }

    private Search() {
    }
}

