/*
 * Decompiled with CFR 0.152.
 */
package nxtdesktop;

import java.awt.Desktop;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import javafx.application.Platform;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import nxt.Nxt;
import nxt.http.API;
import nxt.util.JSON;
import nxt.util.Logger;
import nxtdesktop.DesktopApplication;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;

public class JavaScriptBridge {
    DesktopApplication application;
    private Clipboard clipboard;

    public JavaScriptBridge(DesktopApplication desktopApplication) {
        this.application = desktopApplication;
    }

    public void log(String string) {
        Logger.logInfoMessage(string);
    }

    public void openBrowser(String string) {
        String string2 = API.getWelcomePageUri().toString() + "?account=" + string;
        Platform.runLater(() -> {
            try {
                Desktop.getDesktop().browse(new URI(string2));
            }
            catch (Exception exception) {
                Logger.logInfoMessage("Cannot open " + API.getWelcomePageUri().toString() + " error " + exception.getMessage());
            }
        });
    }

    public String readContactsFile() {
        byte[] byArray;
        String string = "contacts.json";
        try {
            byArray = Files.readAllBytes(Paths.get(Nxt.getUserHomeDir(), string));
        }
        catch (IOException iOException) {
            Logger.logInfoMessage("Cannot read file " + string + " error " + iOException.getMessage());
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"error", (Object)"contacts_file_not_found");
            jSONObject.put((Object)"file", (Object)string);
            jSONObject.put((Object)"folder", (Object)Nxt.getUserHomeDir());
            jSONObject.put((Object)"type", (Object)"1");
            return JSON.toJSONString((JSONAware)jSONObject);
        }
        try {
            return new String(byArray, "utf8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.logInfoMessage("Cannot parse file " + string + " content error " + unsupportedEncodingException.getMessage());
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"error", (Object)"unsupported_encoding");
            jSONObject.put((Object)"type", (Object)"2");
            return JSON.toJSONString((JSONAware)jSONObject);
        }
    }

    public String getAdminPassword() {
        return API.adminPassword;
    }

    public void popupHandlerURLChange(String string) {
        this.application.popupHandlerURLChange(string);
    }

    public boolean copyText(String string) {
        if (this.clipboard == null) {
            this.clipboard = Clipboard.getSystemClipboard();
            if (this.clipboard == null) {
                return false;
            }
        }
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putString(string);
        return this.clipboard.setContent((Map)clipboardContent);
    }
}

