/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.util.List;
import org.jf.baksmali.DexInputCommand;
import org.jf.baksmali.formatter.BaksmaliFormatter;
import org.jf.dexlib2.iface.reference.Reference;

public abstract class ListReferencesCommand
extends DexInputCommand {
    private final int referenceType;
    @Parameter(names={"-h", "-?", "--help"}, help=true, description="Show usage information")
    private boolean help;

    public ListReferencesCommand(List<JCommander> commandAncestors, int referenceType) {
        super(commandAncestors);
        this.referenceType = referenceType;
    }

    @Override
    public void run() {
        if (this.help || this.inputList == null || this.inputList.isEmpty()) {
            this.usage();
            return;
        }
        if (this.inputList.size() > 1) {
            System.err.println("Too many files specified");
            this.usage();
            return;
        }
        String input = (String)this.inputList.get(0);
        this.loadDexFile(input);
        BaksmaliFormatter formatter = new BaksmaliFormatter();
        for (Reference reference : this.dexFile.getReferences(this.referenceType)) {
            System.out.println(formatter.getReference(reference));
        }
    }
}

