/*
 * Decompiled with CFR 0.152.
 */
package kickass._65xx;

import kickass._65xx._65xxArgType;
import kickass._65xx._65xxArgumentExpr;
import kickass.common.errors.AsmError;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.ByteOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.LabelValue;
import kickass.pass.values.NumberValue;
import kickass.pass.values.Value;
import kickass.pass.values._65xxArgumentValue;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.SymbolStatus;

public class _65xxMnemonicNode
extends AsmDirective {
    private String mnemonic;
    private ExprNode argExpr;
    private int[] modes;
    private _65xxArgType argType;
    private String argLabelName;
    private ForceMode forceMode;
    private ISymbolPageIdx argLabelsymbolPageIdx;
    private boolean labelIsResolved = false;

    private static _65xxArgType resolveExtension(String string, SourceRange sourceRange, EvaluationState evaluationState) {
        if (string.equals("imm") || string.equals("im")) {
            return _65xxArgType.immediate;
        }
        if (string.equals("zpx") || string.equals("zx")) {
            return _65xxArgType.zeropageX;
        }
        if (string.equals("zpy") || string.equals("zy")) {
            return _65xxArgType.zeropageY;
        }
        if (string.equals("izpx") || string.equals("izx")) {
            return _65xxArgType.indirectZeropageX;
        }
        if (string.equals("izpy") || string.equals("izy")) {
            return _65xxArgType.indirectZeropageY;
        }
        if (string.equals("absx") || string.equals("ax")) {
            return _65xxArgType.absoluteX;
        }
        if (string.equals("absy") || string.equals("ay")) {
            return _65xxArgType.absoluteY;
        }
        if (string.equals("ind") || string.equals("i")) {
            return _65xxArgType.indirect;
        }
        if (string.equals("rel") || string.equals("r")) {
            return _65xxArgType.relative;
        }
        evaluationState.errorMgr.addError(new AsmError("Unknown extension: " + string, sourceRange));
        return null;
    }

    public static _65xxMnemonicNode createNode(String string, String string2, _65xxArgType _65xxArgType2, ExprNode exprNode, int[] nArray, String string3, SourceRange sourceRange, EvaluationState evaluationState) {
        ForceMode forceMode = null;
        _65xxArgType _65xxArgType3 = null;
        if (string2 != null) {
            if (string2.equals("zp") || string2.equals("z")) {
                forceMode = ForceMode.zp;
            } else if (string2.equals("abs") || string2.equals("a")) {
                forceMode = ForceMode.abs;
            } else {
                _65xxArgType3 = _65xxMnemonicNode.resolveExtension(string2, sourceRange, evaluationState);
                if (_65xxArgType3 == null) {
                    return null;
                }
            }
        }
        boolean bl = _65xxArgType2 == _65xxArgType.unresolvedAbsolute;
        _65xxArgumentExpr _65xxArgumentExpr2 = new _65xxArgumentExpr(_65xxArgType2, exprNode, bl);
        return new _65xxMnemonicNode(string, _65xxArgType3, _65xxArgumentExpr2, nArray, string3, forceMode, sourceRange);
    }

    public _65xxMnemonicNode(String string, _65xxArgType _65xxArgType2, ExprNode exprNode, int[] nArray, String string2, ForceMode forceMode, SourceRange sourceRange) {
        super(sourceRange);
        this.argExpr = exprNode;
        this.mnemonic = string;
        this.argType = _65xxArgType2;
        this.modes = nArray;
        this.argLabelName = string2;
        this.forceMode = forceMode;
    }

    private _65xxMnemonicNode(String string, _65xxArgType _65xxArgType2, ExprNode exprNode, int[] nArray, String string2, ForceMode forceMode, SourceRange sourceRange, ISymbolPageIdx iSymbolPageIdx) {
        super(sourceRange);
        this.argExpr = exprNode;
        this.mnemonic = string;
        this.argType = _65xxArgType2;
        this.modes = nArray;
        this.argLabelName = string2;
        this.argLabelsymbolPageIdx = iSymbolPageIdx;
        this.forceMode = forceMode;
    }

    @Override
    public AsmNode copy() {
        return new _65xxMnemonicNode(this.mnemonic, this.argType, this.argExpr, this.modes, this.argLabelName, this.forceMode, this.range, this.argLabelsymbolPageIdx);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        if (this.argLabelName != null) {
            boolean bl = this.argLabelName.startsWith("@");
            String string = bl ? this.argLabelName.substring(1) : this.argLabelName;
            SymbolScope symbolScope = evaluationState.scopeMgr.getRootOrCurrentScope(bl);
            if (symbolScope.isDefined(string)) {
                evaluationState.errorMgr.addError(new AsmError("The symbol '" + string + "' is already defined", this.range));
                return this;
            }
            this.argLabelsymbolPageIdx = symbolScope.define(string, LabelValue.getInitializer(evaluationState));
            this.argLabelsymbolPageIdx.setStatus(SymbolStatus.defined);
            this.argLabelsymbolPageIdx.setIsScopeExposed(true);
        }
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.argExpr.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        Value value;
        Value value2;
        Value value3;
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        boolean bl = false;
        if (this.argLabelName != null && !this.labelIsResolved) {
            int n = evaluationState.segmentMgr.getMemoryPosition();
            if (n < 0) {
                bl = true;
            } else {
                value3 = (LabelValue)this.argLabelsymbolPageIdx.getValueHolder().getWithoutSideeffect();
                ((LabelValue)value3).resolveLabel(new NumberValue(n + 1));
                evaluationState.scopeMgr.addResolvedSymbol(this.argLabelName, n + 1);
                evaluationState.setMadeMetaProgress();
                this.labelIsResolved = true;
            }
        }
        Integer n = (value2 = ((_65xxArgumentValue)(value3 = _65xxArgumentValue.get65xxArg(value = this.argExpr.evaluate(evaluationState), this.range))).getValue()).isInvalid() || ((_65xxArgumentValue)value3).get65xxArgType() == _65xxArgType.noArgument ? null : Integer.valueOf(value2.getInt(this.range));
        boolean bl2 = value2.isZeropageBound();
        if (this.argType == null) {
            this.argType = ((_65xxArgumentValue)value3).get65xxArgType();
        }
        if (!this.argType.isResolved()) {
            this.argType = this.resolveArgType(this.argType, n, bl2, this.modes);
        }
        int n2 = 1 + this.argType.getByteSize();
        evaluationState.segmentMgr.increaseMemoryPosition(n2);
        int n3 = this.modes[this.argType.getIdNo()];
        if (n3 == -1) {
            throw new AsmErrorException("invalid adressingmode. '" + this.mnemonic + "' doesn't support " + (Object)((Object)this.argType) + " mode", this.range);
        }
        if (value2.isInvalid()) {
            return this;
        }
        if (this.argType == _65xxArgType.relative) {
            int n4 = evaluationState.segmentMgr.getMemoryPosition();
            if (n4 < 0) {
                return this;
            }
            if ((n = Integer.valueOf(n - n4)) < -128 || 127 < n) {
                throw new AsmErrorException("relative address is illegal (jump distance is too far).", this.range);
            }
        }
        byte[] byArray = new byte[n2];
        byArray[0] = (byte)n3;
        for (int i = 1; i < n2; ++i) {
            byArray[i] = (byte)(n & 0xFF);
            n = n >> 8;
        }
        if (bl || evaluationState.sideeffectMgr.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        return new ByteOutput(byArray, this.range, evaluationState.sideeffectMgr.getFunctionSideOutput());
    }

    private _65xxArgType resolveArgType(_65xxArgType _65xxArgType2, Integer n, boolean bl, int[] nArray) {
        boolean bl2;
        boolean bl3;
        if (this.forceMode == ForceMode.abs) {
            return _65xxArgType2.getAbsForm();
        }
        _65xxArgType _65xxArgType3 = _65xxArgType2.getZpForm();
        boolean bl4 = _65xxArgType3 != null && nArray[_65xxArgType3.getIdNo()] >= 0;
        boolean bl5 = bl3 = n != null && n <= 255;
        if (bl4 && (bl || bl3 || this.forceMode == ForceMode.zp)) {
            return _65xxArgType3;
        }
        boolean bl6 = nArray[_65xxArgType.relative.getIdNo()] >= 0;
        boolean bl7 = bl2 = _65xxArgType2.getRelForm() != null;
        if (bl6 && bl2) {
            return _65xxArgType.relative;
        }
        return _65xxArgType2.getAbsForm();
    }

    @Override
    public String toString() {
        return this.mnemonic;
    }

    private static enum ForceMode {
        abs,
        zp;

    }
}

