/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.preprocessor.directives;

import kickass.common.errors.AsmError;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokenstreams.TokenStreamList;
import kickass.parsing.preprocessor.IfState;
import kickass.parsing.preprocessor.PreProcessor;
import kickass.parsing.preprocessor.directives.IPreProcessorDirective;
import kickass.parsing.preprocessor.directives.PpdUtil;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.state.EvaluationState;

public class PpdElse
implements IPreProcessorDirective {
    private PreProcessor preprocessor;

    public PpdElse(PreProcessor preProcessor) {
        this.preprocessor = preProcessor;
    }

    @Override
    public void executeDirective(IToken iToken, TokenStreamList tokenStreamList) {
        IfState ifState;
        EvaluationState evaluationState = this.preprocessor.getState();
        if (!PpdUtil.ensureNoOfArguments(iToken, 0, tokenStreamList, evaluationState)) {
            return;
        }
        SourceRange sourceRange = iToken.getSourceRange();
        IfState ifState2 = evaluationState.preprocessorMgr.popState(sourceRange);
        if (ifState2 == null) {
            evaluationState.errorMgr.addError(new AsmError("Else without if", sourceRange));
            return;
        }
        if (ifState2 == IfState.ifTaken) {
            ifState = IfState.elseNotTaken;
        } else if (ifState2 == IfState.ifNotTaken) {
            ifState = IfState.elseTaken;
        } else if (ifState2 == IfState.unevaluatedIf) {
            ifState = IfState.unevaluatedElse;
        } else {
            evaluationState.errorMgr.addError(new AsmError("Else without if", iToken.getSourceRange()));
            return;
        }
        evaluationState.preprocessorMgr.pushState(ifState, iToken.getSourceRange());
    }
}

