/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.sourcelocation;

public class SourceRange {
    private int startLineNo;
    private int startLinePos;
    private int endLineNo;
    private int endLinePos;
    private String fileName;

    public static SourceRange createEofRange(int n, int n2, String string) {
        return new SourceRange(n, n2, -1, -1, string);
    }

    public SourceRange(int n, int n2, String string) {
        this.startLineNo = n;
        this.startLinePos = n2;
        this.fileName = string;
    }

    public SourceRange(int n, int n2, int n3, int n4, String string) {
        this.startLineNo = n;
        this.startLinePos = n2;
        this.endLineNo = n3;
        this.endLinePos = n4;
        this.fileName = string;
    }

    public SourceRange(SourceRange sourceRange, SourceRange sourceRange2) {
        if (sourceRange.isEof() || sourceRange2.isEof()) {
            throw new RuntimeException("Fatal error, can't combine an eof range");
        }
        this.startLineNo = sourceRange.startLineNo;
        this.startLinePos = sourceRange.startLinePos;
        this.endLineNo = sourceRange2.endLineNo;
        this.endLinePos = sourceRange2.endLinePos;
        this.fileName = sourceRange.fileName;
    }

    public void setEndPos(int n, int n2) {
        this.endLineNo = n;
        this.endLinePos = n2;
    }

    public boolean isEof() {
        return this.getEndLineNo() < 0;
    }

    public int getStartLineNo() {
        return this.startLineNo;
    }

    public int getStartLinePos() {
        return this.startLinePos;
    }

    public int getEndLineNo() {
        return this.endLineNo;
    }

    public int getEndLinePos() {
        return this.endLinePos;
    }

    public String getFileName() {
        return this.fileName;
    }
}

