/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kickass.nonasm.tools.StringTool;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.metanodes.ScopeNode;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.asmnode.output.reciever.CodeCollectorOutputReciever;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.segments.MemoryBlock;
import kickass.state.segments.Segment;
import kickass.state.segments.SegmentType;

public class AssertCodeDirective
extends AsmDirective {
    ExprNode msgExpr;
    AsmNode resultNode;
    AsmNode expectedNode;
    SourceRange range;

    public AssertCodeDirective(ExprNode exprNode, AsmNode asmNode, AsmNode asmNode2, SourceRange sourceRange) {
        super(sourceRange);
        this.msgExpr = exprNode;
        this.resultNode = asmNode;
        this.expectedNode = asmNode2;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.scopeMgr.getCurrentScope();
        SymbolScope symbolScope2 = new SymbolScope(symbolScope, null);
        SymbolScope symbolScope3 = new SymbolScope(symbolScope, null);
        this.resultNode = new ScopeNode(this.resultNode, symbolScope2);
        this.expectedNode = new ScopeNode(this.expectedNode, symbolScope3);
        this.resultNode = this.resultNode.executeMetaRegistrations(evaluationState);
        this.expectedNode = this.expectedNode.executeMetaRegistrations(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.resultNode = this.resultNode.executePrepass(evaluationState);
        this.expectedNode = this.expectedNode.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        boolean bl;
        Segment segment = evaluationState.segmentMgr.getCurrentSegment();
        Segment segment2 = new Segment("Result", SegmentType.input);
        segment2.initPass();
        evaluationState.segmentMgr.switchToSegmentWithoutSideEffect(segment2);
        this.resultNode = this.resultNode.executePass(evaluationState);
        Segment segment3 = new Segment("Expected", SegmentType.input);
        segment3.initPass();
        evaluationState.segmentMgr.switchToSegmentWithoutSideEffect(segment3);
        this.expectedNode = this.expectedNode.executePass(evaluationState);
        evaluationState.segmentMgr.switchToSegmentWithoutSideEffect(segment);
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        Value value = this.msgExpr.evaluate(evaluationState);
        boolean bl2 = evaluationState.sideeffectMgr.getErrorOrInvalidSideEffectsDuringFunctionEvaluation();
        boolean bl3 = bl = this.resultNode.isFinished() && this.expectedNode.isFinished() && !bl2;
        if (!bl) {
            return this;
        }
        String string = value.getString(this.range);
        CodeCollectorOutputReciever codeCollectorOutputReciever = new CodeCollectorOutputReciever(8192, evaluationState.parameters.maxMemoryAddress, evaluationState.log);
        CodeCollectorOutputReciever codeCollectorOutputReciever2 = new CodeCollectorOutputReciever(8192, evaluationState.parameters.maxMemoryAddress, evaluationState.log);
        this.resultNode.deliverOutput(codeCollectorOutputReciever);
        this.expectedNode.deliverOutput(codeCollectorOutputReciever2);
        boolean bl4 = codeCollectorOutputReciever.codeIsEqual(codeCollectorOutputReciever2);
        String string2 = bl4 ? string + " -- OK. | " + this.codeToString(codeCollectorOutputReciever) : string + " -- FAILED! | " + this.codeToString(codeCollectorOutputReciever) + "  -- " + this.codeToString(codeCollectorOutputReciever2);
        evaluationState.sideeffectMgr.addTextOutput(string2);
        evaluationState.assertMgr.madeAssert(!bl4);
        return new SideEffectOnlyOutput(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }

    private String codeToString(CodeCollectorOutputReciever codeCollectorOutputReciever) {
        StringBuffer stringBuffer = new StringBuffer();
        Map<String, List<MemoryBlock>> map = codeCollectorOutputReciever.getSegments();
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        for (String string : arrayList) {
            if (arrayList.size() != 1) {
                stringBuffer.append(string + ": ");
            }
            boolean bl = true;
            for (MemoryBlock memoryBlock : map.get(string)) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append("; ");
                }
                stringBuffer.append(StringTool.toHexString(memoryBlock.getStartAdress(), 4));
                stringBuffer.append(":");
                boolean bl2 = true;
                for (byte by : memoryBlock.getMemory()) {
                    if (bl2) {
                        bl2 = false;
                    } else {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(StringTool.toHexString(by, 2));
                }
            }
        }
        return stringBuffer.toString();
    }
}

