/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.List;
import kickass.common.errors.AsmError;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class AssertErrorDirective
extends AsmDirective {
    private ExprNode testNameExpr;
    private ExprNode expr;
    private SourceRange range;
    private List<AsmError> errorsFound = null;
    boolean preparsed = false;

    public AssertErrorDirective(ExprNode exprNode, ExprNode exprNode2, SourceRange sourceRange) {
        super(sourceRange);
        this.testNameExpr = exprNode;
        this.expr = exprNode2;
    }

    @Override
    public AsmNode copy() {
        return new AssertErrorDirective(this.testNameExpr, this.expr, this.range);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.testNameExpr.executePrepass(evaluationState);
        evaluationState.errorMgr.startExpectErrorsMode();
        this.expr.executePrepass(evaluationState);
        this.errorsFound = evaluationState.errorMgr.endExpectErrorsMode();
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        int n = evaluationState.callStack.getStackSize();
        AsmError asmError = null;
        if (!this.errorsFound.isEmpty()) {
            asmError = this.errorsFound.get(0);
        } else {
            try {
                this.expr.evaluate(evaluationState);
            }
            catch (AsmErrorException asmErrorException) {
                asmError = asmErrorException.getError();
            }
        }
        evaluationState.callStack.popTilDepth(n);
        Value value = this.testNameExpr.evaluate(evaluationState);
        boolean bl = evaluationState.sideeffectMgr.getErrorOrInvalidSideEffectsDuringFunctionEvaluation();
        if (asmError == null && bl) {
            return this;
        }
        String string = value.getString(this.range);
        String string2 = asmError != null ? string + " -- OK. | " + asmError.getMessage() : string + " -- ERROR IN ASSERTION!";
        evaluationState.sideeffectMgr.addTextOutput(string2);
        evaluationState.assertMgr.madeAssert(asmError == null);
        return new SideEffectOnlyOutput(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }
}

