/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.List;
import kickass.common.errors.AsmError;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.Directive;
import kickass.pass.asmnode.output.EmptyOutput;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class ErrorIfDirective
extends Directive {
    private List<ExprNode> argExprs;

    public ErrorIfDirective(List<ExprNode> list, SourceRange sourceRange) {
        super(sourceRange);
        this.argExprs = list;
        this.range = sourceRange;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        if (this.argExprs.size() != 2) {
            evaluationState.errorMgr.addError(new AsmError("Invalid number of arguments.", this.range));
            return EmptyOutput.instance;
        }
        for (ExprNode exprNode : this.argExprs) {
            exprNode.executePrepass(evaluationState);
        }
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        Value value = this.argExprs.get(0).evaluate(evaluationState);
        if (value.isInvalid()) {
            return this;
        }
        if (value.getBoolean(this.range)) {
            Value value2 = this.argExprs.get(1).evaluate(evaluationState);
            if (value2.isInvalid()) {
                return this;
            }
            String string = value2.getString(this.range);
            throw new AsmErrorException(string, this.range);
        }
        return new SideEffectOnlyOutput(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }
}

