/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.misc.ParameterMap;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.Directive;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.state.EvaluationState;
import kickass.state.segments.C64File;
import kickass.state.segments.C64FileType;
import kickass.state.segments.Segment;
import kickass.state.segments.SegmentParser;

public class FileDirective
extends Directive {
    private static final String param_name = "name";
    private static final String param_type = "type";
    private static final String param_mbfiles = "mbfiles";
    private static final Set<String> allParameters = new HashSet<String>(Arrays.asList("name", "type", "mbfiles"));
    private ParameterMap parameters;

    public FileDirective(ParameterMap parameterMap, SourceRange sourceRange) {
        super(sourceRange);
        this.parameters = parameterMap;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.parameters.addErrorIfNotExist(param_name, evaluationState);
        this.parameters.addErrorsForUnknownParameres(allParameters, evaluationState);
        this.parameters.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        if (!this.parameters.evaluateAllParameters(evaluationState)) {
            return this;
        }
        String string = this.parameters.getStringValue(param_name);
        if (evaluationState.segmentMgr.c64FileExist(string)) {
            throw new AsmErrorException("There already exist a file with the name of: " + string, this.parameters.getNameRange(param_name));
        }
        Segment segment = SegmentParser.createCombiSegment(new Segment("<<" + string + ">>"), this.parameters, evaluationState);
        evaluationState.segmentMgr.addSegment(segment);
        C64File c64File = new C64File(string, segment.getName());
        String string2 = this.parameters.getStringValue(param_type, null);
        if (string2 != null) {
            try {
                c64File.setType(C64FileType.valueOf(string2));
            }
            catch (Exception exception) {
                throw new AsmErrorException("Unknown type: " + string2, this.parameters.getNameRange(param_type));
            }
        }
        c64File.setMbFiles(this.parameters.getBoolValue(param_mbfiles, false));
        evaluationState.segmentMgr.addC64File(c64File);
        return new SideEffectOnlyOutput(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }

    static {
        allParameters.addAll(SegmentParser.allCombiSegmentParameters);
    }
}

