/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.List;
import kickass.common.errors.AsmError;
import kickass.common.exceptions.ShouldNotBeHereException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.directives.UserFunction;
import kickass.pass.asmnode.output.EmptyOutput;
import kickass.pass.function.Function;
import kickass.pass.function.functionselector.IFunctionSelector;
import kickass.pass.function.functionselector.MultiFunctionSelector;
import kickass.pass.functionnode.FunctionNode;
import kickass.state.EvaluationState;
import kickass.state.scope.EntityScope;

public class FunctionDeclarationDirective
extends AsmDirective {
    private boolean isRootScope;
    private String name;
    private List<String> argumentNames;
    private List<FunctionNode> body;
    private UserFunction function;

    public FunctionDeclarationDirective(String string, List<String> list, List<FunctionNode> list2, SourceRange sourceRange) {
        super(sourceRange);
        this.isRootScope = string.startsWith("@");
        this.name = this.isRootScope ? string.substring(1) : string;
        this.argumentNames = list;
        this.body = list2;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        boolean bl;
        boolean bl2;
        EntityScope<IFunctionSelector> entityScope = evaluationState.namespaceMgr.getRootOrCurrentNamespace(this.isRootScope).getFunctions();
        IFunctionSelector iFunctionSelector = entityScope.getLocalDefinedEntities().get(this.name);
        if (iFunctionSelector == null) {
            iFunctionSelector = new MultiFunctionSelector(this.name, new Function[0]);
            entityScope.put(this.name, iFunctionSelector);
        }
        boolean bl3 = bl2 = evaluationState.namespaceMgr.getCurrentNamespace().getScope() == evaluationState.scopeMgr.getCurrentScope();
        if (!bl2) {
            evaluationState.errorMgr.addError(new AsmError("Can't define a function here. Define it in the direct scope of the current namespace, not inside constructs like {}, .if, .for, etc.", this.range));
            return EmptyOutput.instance;
        }
        this.function = new UserFunction(this.name, this.argumentNames, this.body, evaluationState.namespaceMgr.getCurrentNamespace(), this.range);
        boolean bl4 = bl = !iFunctionSelector.addFunction(this.function);
        if (bl) {
            evaluationState.errorMgr.addError(new AsmError("The function '" + this.name + "' is already defined.", this.range));
        }
        this.function.registerMetaDefinitions(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.function.executePrepass(evaluationState);
        return EmptyOutput.instance;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        throw new ShouldNotBeHereException();
    }
}

