/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.asmnode.output.reciever.CodeCollectorOutputReciever;
import kickass.pass.asmnode.output.reciever.IOutputReciever;
import kickass.pass.asmnode.output.reciever.OutputStreamType;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.plugins.impl.PluginEngine;
import kickass.plugins.impl.PluginValue;
import kickass.plugins.interf.IMemoryBlock;
import kickass.plugins.interf.IModifier;
import kickass.plugins.interf.IValue;
import kickass.state.EvaluationState;
import kickass.state.FunctionSideOutput;
import kickass.state.segments.MemoryBlock;
import kickass.state.segments.Segment;
import kickass.state.segments.SegmentManager;
import kickass.state.segments.SegmentType;

public class ModifyDirective
extends AsmDirective {
    private String name;
    private List<ExprNode> argumentExprs;
    private AsmNode body;
    private boolean isFinished = false;
    private FunctionSideOutput sideOutputFromArguments;
    private byte[] modifiedBytes;

    public ModifyDirective(String string, List<ExprNode> list, AsmNode asmNode, SourceRange sourceRange) {
        super(sourceRange);
        this.name = string;
        this.argumentExprs = list;
        this.body = asmNode;
    }

    @Override
    public AsmNode copy() {
        return new ModifyDirective(this.name, this.argumentExprs, this.body.copy(), this.range);
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        Object object;
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        boolean bl = false;
        IValue[] iValueArray = new IValue[this.argumentExprs.size()];
        for (int i = 0; i < iValueArray.length; ++i) {
            object = this.argumentExprs.get(i).evaluate(evaluationState);
            bl |= ((Value)object).isInvalid();
            iValueArray[i] = new PluginValue((Value)object, this.range);
        }
        this.sideOutputFromArguments = evaluationState.sideeffectMgr.getFunctionSideOutput();
        SegmentManager segmentManager = evaluationState.segmentMgr;
        object = evaluationState.segmentMgr.getCurrentSegment();
        String string = "<<modify>>";
        Segment segment = new Segment(string, SegmentType.input);
        segment.initPass();
        evaluationState.segmentMgr.switchToSegmentWithoutSideEffect(segment);
        this.body = this.body.executePass(evaluationState);
        evaluationState.segmentMgr.switchToSegmentWithoutSideEffect((Segment)object);
        if (bl || !this.body.isFinished()) {
            return this.invalidatePcAndReturnThis(evaluationState);
        }
        if (this.modifiedBytes == null) {
            CodeCollectorOutputReciever codeCollectorOutputReciever = new CodeCollectorOutputReciever(8192, evaluationState.parameters.maxMemoryAddress, evaluationState.log);
            codeCollectorOutputReciever.switchSegment(segment.getName(), 8192);
            this.body.deliverOutput(codeCollectorOutputReciever);
            List<MemoryBlock> list = codeCollectorOutputReciever.getSegments().get(string);
            ArrayList<IMemoryBlock> arrayList = new ArrayList<IMemoryBlock>();
            for (MemoryBlock object22 : list) {
                if (object22.isVirtual()) continue;
                arrayList.add(object22.getPluginMemoryBlock());
            }
            IModifier iModifier = evaluationState.namespaceMgr.getSystemNamespace().getModifierPlugins().get(this.name);
            if (iModifier == null) {
                throw new AsmErrorException("Unknown modifyer: " + this.name, this.range);
            }
            PluginEngine pluginEngine = new PluginEngine(evaluationState, this.range);
            this.modifiedBytes = iModifier.execute(arrayList, iValueArray, pluginEngine);
        }
        segmentManager.increaseMemoryPosition(this.modifiedBytes.length);
        this.isFinished = true;
        return this;
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public void deliverOutput(IOutputReciever iOutputReciever) {
        new SideEffectOnlyOutput(this.sideOutputFromArguments).deliverOutput(iOutputReciever);
        this.body.deliverOutput(new ByteOutputFilter(iOutputReciever));
        iOutputReciever.addAssembledBytes(this.modifiedBytes, this.range);
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.body.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        this.body.executeMetaRegistrations(evaluationState);
        return this;
    }

    static class ByteOutputFilter
    implements IOutputReciever {
        private IOutputReciever reciever;

        public ByteOutputFilter(IOutputReciever iOutputReciever) {
            this.reciever = iOutputReciever;
        }

        @Override
        public void addToStream(OutputStreamType outputStreamType, String string, Object object) {
            this.reciever.addToStream(outputStreamType, string, object);
        }

        @Override
        public void addAssembledBytes(byte[] byArray, SourceRange sourceRange) {
        }

        @Override
        public void startNewMemoryBlock(Integer n, String string, boolean bl) {
        }

        @Override
        public void switchSegment(String string, int n) {
        }

        @Override
        public Map<String, List<MemoryBlock>> getSegments() {
            return this.reciever.getSegments();
        }
    }
}

