/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import kickass.common.exceptions.AsmErrorException;
import kickass.common.exceptions.NotImplementedException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.directives.Directive;
import kickass.pass.asmnode.output.EmptyOutput;
import kickass.state.EvaluationState;

public class PluginDirective
extends AsmDirective {
    private String className;

    public PluginDirective(String string, SourceRange sourceRange) {
        super(sourceRange);
        this.className = string;
    }

    @Override
    public Directive copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        Object obj;
        Class<?> clazz;
        try {
            clazz = Class.forName(this.className);
        }
        catch (Exception exception) {
            throw new AsmErrorException("Can't find class for plugin", this.range);
        }
        try {
            obj = clazz.newInstance();
        }
        catch (Exception exception) {
            throw new AsmErrorException("Plugin found but can't instantiate it", this.range);
        }
        evaluationState.namespaceMgr.addPlugin(obj);
        return EmptyOutput.instance;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        throw new NotImplementedException();
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        throw new NotImplementedException();
    }
}

