/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.StartOfMemoryBlockOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class SoftMemoryBlock
extends AsmDirective {
    private ExprNode nameExpr;

    public SoftMemoryBlock(ExprNode exprNode, SourceRange sourceRange) {
        super(sourceRange);
        this.nameExpr = exprNode;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.nameExpr.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        Value value = this.nameExpr.evaluate(evaluationState);
        if (value.isInvalid()) {
            return this;
        }
        if (evaluationState.sideeffectMgr.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        String string = value.getString(this.range);
        boolean bl = evaluationState.segmentMgr.getCurrentSegment().isVirtual();
        return new StartOfMemoryBlockOutput(null, string, bl, evaluationState.sideeffectMgr.getFunctionSideOutput());
    }
}

