/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.List;
import kickass.common.errors.AsmError;
import kickass.common.exceptions.AsmErrorException;
import kickass.common.exceptions.AsmException;
import kickass.common.exceptions.ShouldNotBeHereException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.EmptyOutput;
import kickass.pass.function.Function;
import kickass.pass.function.functionselector.IFunctionSelector;
import kickass.pass.function.functionselector.SingleFunctionAnyArgSelector;
import kickass.pass.values.StructValue;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.scope.EntityScope;

public class StructDirective
extends AsmDirective {
    private boolean isRootScope;
    private String name;
    private List<String> variableNames;

    public StructDirective(String string, List<String> list, SourceRange sourceRange) {
        super(sourceRange);
        this.isRootScope = string.startsWith("@");
        this.name = this.isRootScope ? string.substring(1) : string;
        this.variableNames = list;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        EntityScope<IFunctionSelector> entityScope = evaluationState.namespaceMgr.getRootOrCurrentNamespace(this.isRootScope).getFunctions();
        boolean bl = entityScope.getLocalDefinedEntities().containsKey(this.name);
        if (bl) {
            evaluationState.errorMgr.addError(new AsmError("Can't define constructor for the struct '" + this.name + "'. The function name is already used", this.range));
            return EmptyOutput.instance;
        }
        StructConstructor structConstructor = new StructConstructor(this.name, this.variableNames);
        entityScope.put(structConstructor.getName(), new SingleFunctionAnyArgSelector(structConstructor));
        return EmptyOutput.instance;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        throw new ShouldNotBeHereException();
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        throw new ShouldNotBeHereException();
    }

    private static class StructConstructor
    extends Function {
        private List<String> variableNames;

        public StructConstructor(String string, List<String> list) {
            super(string, null, null, true);
            this.variableNames = list;
        }

        @Override
        public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) throws AsmException {
            StructValue structValue = null;
            if (valueArray.length == 0) {
                structValue = new StructValue(this.getName(), this.variableNames, null);
            }
            if (valueArray.length == this.variableNames.size()) {
                structValue = new StructValue(this.getName(), this.variableNames, valueArray);
            }
            if (structValue == null) {
                throw new AsmErrorException("Invalid number of arguments for struct constructor", sourceRange);
            }
            return structValue;
        }
    }
}

