/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.output.reciever;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.state.EvaluationState;

public class ByteDumpWriter {
    private EvaluationState state;
    private SegmentData currentSegment = null;
    private Map<String, SegmentData> segments = new HashMap<String, SegmentData>();
    private String filename;
    private Map<String, List<String>> sourceFileLines = new HashMap<String, List<String>>();

    public ByteDumpWriter(String string, EvaluationState evaluationState) throws IOException {
        this.filename = string;
        this.state = evaluationState;
    }

    public void switchSegment(String string) {
        this.currentSegment = this.segments.get(string);
        if (this.currentSegment != null) {
            return;
        }
        this.currentSegment = new SegmentData();
        StringBuilder stringBuilder = this.currentSegment.stringBuilder;
        this.segments.put(string, this.currentSegment);
        int n = 80;
        String string2 = " Segment: " + string + " ";
        String string3 = "********************************************************************************";
        int n2 = Math.max(4, n - string2.length());
        int n3 = n2 / 2;
        int n4 = n2 - n3;
        stringBuilder.append(string3.subSequence(0, n3));
        stringBuilder.append(string2);
        stringBuilder.append(string3.subSequence(0, n4));
        stringBuilder.append("\n");
    }

    public void closeStreams() {
        try {
            OutputStream outputStream = this.state.outputMgr.OpenOutputStream(this.filename, false);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            ArrayList<String> arrayList = new ArrayList<String>(this.segments.keySet());
            Collections.sort(arrayList);
            for (String string : arrayList) {
                SegmentData segmentData = this.segments.get(string);
                outputStreamWriter.write(segmentData.stringBuilder.toString());
            }
            ((Writer)outputStreamWriter).close();
            outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startMemoryBlock(int n, String string, boolean bl) {
        StringBuilder stringBuilder = this.currentSegment.stringBuilder;
        this.currentSegment.currentAddress = n;
        this.currentSegment.isVirtual = bl;
        if (string == null) {
            string = "Unnamed";
        }
        if (this.currentSegment.isFirstBlock) {
            this.currentSegment.isFirstBlock = false;
        } else {
            stringBuilder.append("\n");
        }
        stringBuilder.append("[" + string + "]\n");
    }

    public void printBytes(byte[] byArray, SourceRange sourceRange) {
        try {
            int n;
            int n2 = byArray.length <= 3 ? 3 : (byArray.length <= 64 ? 16 : 32);
            String string = this.getSourceString(sourceRange);
            for (int i = n = 0; i < byArray.length; i += n2) {
                this.writeBytesLine(byArray, i, i + n2, string);
                string = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeBytesLine(byte[] byArray, int n, int n2, String string) {
        StringBuilder stringBuilder = this.currentSegment.stringBuilder;
        if (this.currentSegment.isVirtual) {
            stringBuilder.append("*");
        }
        stringBuilder.append(String.format("%04x: ", this.currentSegment.currentAddress));
        for (int i = n; i < n2; ++i) {
            if (i >= byArray.length) {
                stringBuilder.append("   ");
                continue;
            }
            stringBuilder.append(String.format("%02x ", byArray[i]));
            ++this.currentSegment.currentAddress;
        }
        if (string != null) {
            stringBuilder.append(" - ");
            stringBuilder.append(string);
        }
        stringBuilder.append("\n");
    }

    public List<String> getSourceFileLines(String string) throws IOException {
        String string2;
        List<String> list = this.sourceFileLines.get(string);
        if (list != null) {
            return list;
        }
        FileInputStream fileInputStream = new FileInputStream(this.state.fileMgr.getFile(string, false));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        list = new ArrayList<String>();
        while ((string2 = bufferedReader.readLine()) != null) {
            list.add(string2);
        }
        bufferedReader.close();
        this.sourceFileLines.put(string, list);
        return list;
    }

    private String getSourceString(SourceRange sourceRange) throws IOException {
        List<String> list = this.getSourceFileLines(sourceRange.getFileName());
        if (list == null) {
            return null;
        }
        int n = sourceRange.getStartLineNo() - 1;
        if (n >= list.size()) {
            return null;
        }
        String string = list.get(n);
        return string.substring(sourceRange.getStartLinePos() - 1);
    }

    private class SegmentData {
        public StringBuilder stringBuilder = new StringBuilder();
        public boolean isFirstBlock = true;
        private boolean isVirtual;
        private int currentAddress;

        private SegmentData() {
        }
    }
}

