/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.output.reciever;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kickass.common.exceptions.AsmErrorException;
import kickass.common.log.Logger;
import kickass.common.outputmanager.IOutputManager;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.output.reciever.ByteDumpWriter;
import kickass.pass.asmnode.output.reciever.IOutputReciever;
import kickass.pass.asmnode.output.reciever.OutputStreamType;
import kickass.state.segments.MemoryBlock;

public class MainOutputReciever
implements IOutputReciever {
    private int maxMemoryAddress;
    private Map<String, Writer> fileOutStreams = new HashMap<String, Writer>();
    private ByteDumpWriter byteDumpWriter;
    private int defaultMemoryPos;
    private MemoryBlock currentMemoryBlock;
    private String currentSegmentName;
    private Map<String, List<MemoryBlock>> segments = new HashMap<String, List<MemoryBlock>>();
    private IOutputManager outputManager;
    private Logger log;

    public MainOutputReciever(int n, int n2, ByteDumpWriter byteDumpWriter, IOutputManager iOutputManager, Logger logger) {
        this.log = logger;
        this.outputManager = iOutputManager;
        this.maxMemoryAddress = n2;
        this.byteDumpWriter = byteDumpWriter;
        this.switchSegment("Default", n);
    }

    @Override
    public void switchSegment(String string, int n) {
        this.currentSegmentName = string;
        this.defaultMemoryPos = n;
        List<MemoryBlock> list = this.segments.get(string);
        if (this.segments.get(string) == null) {
            list = new ArrayList<MemoryBlock>();
            this.segments.put(string, list);
        }
        MemoryBlock memoryBlock = this.currentMemoryBlock = list.isEmpty() ? null : list.get(list.size() - 1);
        if (this.byteDumpWriter != null) {
            this.byteDumpWriter.switchSegment(string);
        }
    }

    @Override
    public void addAssembledBytes(byte[] byArray, SourceRange sourceRange) {
        if (this.currentMemoryBlock == null) {
            this.startNewMemoryBlock(null, "unnamed", false);
        }
        this.currentMemoryBlock.addBytes(byArray, null);
        if (this.byteDumpWriter != null) {
            this.byteDumpWriter.printBytes(byArray, sourceRange);
        }
    }

    @Override
    public void startNewMemoryBlock(Integer n, String string, boolean bl) {
        int n2 = n != null ? n : (this.currentMemoryBlock == null ? this.defaultMemoryPos : this.currentMemoryBlock.getStartAdress() + this.currentMemoryBlock.getSize());
        this.currentMemoryBlock = new MemoryBlock(n2, string, bl, this.maxMemoryAddress);
        this.segments.get(this.currentSegmentName).add(this.currentMemoryBlock);
        if (this.byteDumpWriter != null) {
            this.byteDumpWriter.startMemoryBlock(n2, string, bl);
        }
    }

    @Override
    public Map<String, List<MemoryBlock>> getSegments() {
        return this.segments;
    }

    @Override
    public void addToStream(OutputStreamType outputStreamType, String string, Object object) {
        if (outputStreamType == OutputStreamType.CONSOLE) {
            this.log.println("  " + (String)object);
        } else if (outputStreamType == OutputStreamType.FILE) {
            this.addToFileStream(string, object);
        }
    }

    private void addToFileStream(String string, Object object) {
        Writer writer = this.fileOutStreams.get(string);
        if (writer == null) {
            try {
                OutputStream outputStream = this.outputManager.OpenOutputStream(string, true);
                writer = new OutputStreamWriter(outputStream);
            }
            catch (Exception exception) {
                throw new AsmErrorException("Unable to create the file " + string, null);
            }
            this.fileOutStreams.put(string, writer);
        }
        try {
            writer.write((String)object);
        }
        catch (Exception exception) {
            throw new AsmErrorException("Error while writing to file " + string, null);
        }
    }

    public boolean codeIsEqual(IOutputReciever iOutputReciever) {
        Map<String, List<MemoryBlock>> map = iOutputReciever.getSegments();
        if (this.segments.size() != map.size()) {
            return false;
        }
        for (String string : this.segments.keySet()) {
            List<MemoryBlock> list = this.segments.get(string);
            List<MemoryBlock> list2 = map.get(string);
            if (list2 == null) {
                return false;
            }
            if (list.size() != list2.size()) {
                return false;
            }
            for (int i = 0; i < list.size(); ++i) {
                MemoryBlock memoryBlock;
                MemoryBlock memoryBlock2 = list.get(i);
                if (memoryBlock2.contentEquals(memoryBlock = list2.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    private void closeStreams() {
        if (this.byteDumpWriter != null) {
            this.byteDumpWriter.closeStreams();
        }
        for (Writer writer : this.fileOutStreams.values()) {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    public void finish() {
        this.closeStreams();
        if (this.fileOutStreams.isEmpty()) {
            return;
        }
        for (String string : this.fileOutStreams.keySet()) {
            this.log.println("Wrote file: " + string);
        }
    }
}

