/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.functionnode;

import java.util.List;
import kickass.common.errors.AsmError;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.functionnode.FunctionDirective;
import kickass.pass.functionnode.FunctionNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class ErrorIfFDirective
extends FunctionDirective {
    private List<ExprNode> argExprs;

    public ErrorIfFDirective(List<ExprNode> list, SourceRange sourceRange) {
        super(sourceRange);
        this.argExprs = list;
        this.range = sourceRange;
    }

    @Override
    public FunctionNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public FunctionNode executePrepass(EvaluationState evaluationState) {
        if (this.argExprs.size() != 2) {
            evaluationState.errorMgr.addError(new AsmError("Invalid number of arguments.", this.range));
            return this;
        }
        for (ExprNode exprNode : this.argExprs) {
            exprNode.executePrepass(evaluationState);
        }
        return this;
    }

    @Override
    public void executeFunctionPass(EvaluationState evaluationState) {
        Value value = this.argExprs.get(0).evaluate(evaluationState);
        if (value.isInvalid()) {
            evaluationState.sideeffectMgr.setInvalidSideEffectsDuringFunctionEvaluation();
            return;
        }
        if (value.getBoolean(this.range)) {
            Value value2 = this.argExprs.get(1).evaluate(evaluationState);
            if (value2.isInvalid()) {
                evaluationState.sideeffectMgr.setInvalidSideEffectsDuringFunctionEvaluation();
                return;
            }
            String string = value2.getString(this.range);
            throw new AsmErrorException(string, this.range);
        }
    }
}

