/*
 * Decompiled with CFR 0.152.
 */
package kickass.state.namespace;

import java.util.List;
import kickass.common.errors.AsmError;
import kickass.nonasm.tools.collections.MultiEntryMap;
import kickass.pass.function.Function;
import kickass.pass.function.functionselector.FunctionSelectorCreator;
import kickass.pass.function.functionselector.IFunctionSelector;
import kickass.pass.valueholder.ConstantValueHolder;
import kickass.plugins.impl.OldIMacroAdapter;
import kickass.plugins.impl.OldIModifierAdapter;
import kickass.plugins.interf.IArchive;
import kickass.plugins.interf.IMacro;
import kickass.plugins.interf.IModifier;
import kickass.state.EvaluationState;
import kickass.state.libraries.ILibrary;
import kickass.state.libraries.LibConstant;
import kickass.state.namespace.Namespace;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.SymbolStatus;

public class NamespaceManager {
    private EvaluationState state;
    private Namespace systemNamespace = Namespace.createSystemNamespace();
    private Namespace rootNamespace;
    private Namespace currentNamespace = this.rootNamespace = new Namespace("<RootNS>", this.systemNamespace, true);

    public NamespaceManager(EvaluationState evaluationState) {
        this.state = evaluationState;
    }

    public Namespace getRootNamespace() {
        return this.rootNamespace;
    }

    public void setCurrentNamespace(Namespace namespace) {
        this.currentNamespace = namespace;
    }

    public Namespace getCurrentNamespace() {
        return this.currentNamespace;
    }

    public Namespace replaceCurrentNamespace(Namespace namespace) {
        Namespace namespace2 = this.currentNamespace;
        this.currentNamespace = namespace;
        return namespace2;
    }

    public Namespace getSystemNamespace() {
        return this.systemNamespace;
    }

    public Namespace getRootOrCurrentNamespace(boolean bl) {
        return bl ? this.rootNamespace : this.currentNamespace;
    }

    public void addPlugin(Object object) {
        Object object2;
        boolean bl = false;
        if (object instanceof IArchive) {
            object2 = (IArchive)object;
            for (Object object3 : object2.getPluginObjects()) {
                this.addPlugin(object3);
            }
            bl = true;
        }
        if (object instanceof IMacro) {
            object2 = (IMacro)object;
            this.getSystemNamespace().getMacroPlugins().put(object2.getName(), (IMacro)object2);
            bl = true;
        }
        if (object instanceof IModifier) {
            object2 = (IModifier)object;
            this.getSystemNamespace().getModifierPlugins().put(object2.getName(), (IModifier)object2);
            bl = true;
        }
        if (object instanceof cml.kickass.plugins.interf.IArchive) {
            object2 = (cml.kickass.plugins.interf.IArchive)object;
            for (Object object3 : object2.getPluginObjects()) {
                this.addPlugin(object3);
            }
            bl = true;
        }
        if (object instanceof cml.kickass.plugins.interf.IMacro) {
            object2 = (cml.kickass.plugins.interf.IMacro)object;
            this.getSystemNamespace().getMacroPlugins().put(object2.getName(), new OldIMacroAdapter((cml.kickass.plugins.interf.IMacro)object2));
            bl = true;
        }
        if (object instanceof cml.kickass.plugins.interf.IModifier) {
            object2 = (cml.kickass.plugins.interf.IModifier)object;
            this.getSystemNamespace().getModifierPlugins().put(object2.getName(), new OldIModifierAdapter((cml.kickass.plugins.interf.IModifier)object2));
            bl = true;
        }
        if (!bl) {
            this.state.log.println("Warning: The following object registered as a user-plugin but don't implements any plugin interfaces : " + object.getClass().getName());
        }
    }

    public void addLibrary(ILibrary iLibrary, Namespace namespace) {
        Object object;
        String string = iLibrary.getClass().getSimpleName();
        for (LibConstant iterator : iLibrary.getConstants()) {
            SymbolScope symbolScope = namespace.getScope();
            if (symbolScope.isDefined(iterator.getName())) {
                object = "Error while adding the constant '" + iterator.getName() + "' from the library '" + string + "'. The symbol already exist!";
                this.state.errorMgr.addError(new AsmError((String)object, null));
                continue;
            }
            object = symbolScope.define(iterator.getName(), iValueHolderArray -> new ConstantValueHolder(iterator.getValue()));
            object.setStatus(SymbolStatus.defined);
        }
        MultiEntryMap multiEntryMap = new MultiEntryMap();
        for (Function function : iLibrary.getFunctions()) {
            multiEntryMap.add(function.getName(), function);
        }
        for (String string2 : multiEntryMap.keySet()) {
            object = multiEntryMap.get(string2);
            IFunctionSelector iFunctionSelector = FunctionSelectorCreator.create((List<Function>)object);
            namespace.getFunctions().put(string2, iFunctionSelector);
        }
    }
}

