/*
 * Decompiled with CFR 0.152.
 */
package kickass.state.segments;

import cml.kickass.plugins.interf.IMemoryBlock;
import java.io.File;
import java.nio.file.Files;
import java.util.Arrays;
import kickass.common.errors.AsmError;
import kickass.common.exceptions.AsmErrorException;
import kickass.nonasm.tools.collections.ByteArray;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.state.EvaluationState;

public class MemoryBlock {
    private String name;
    private boolean virtual;
    private int maxMemoryAdress = 65535;
    private int startAdress;
    private int size = 0;
    private ByteArray memory;
    private kickass.plugins.interf.IMemoryBlock pluginMemoryBlock = null;

    public static MemoryBlock loadPrgFile(String string, int n, SourceRange sourceRange, EvaluationState evaluationState) {
        byte[] byArray;
        File file = evaluationState.fileMgr.getFile(string, true);
        if (file == null) {
            evaluationState.errorMgr.addError(new AsmError("File doesn't exist: '" + string + "'", sourceRange));
            return null;
        }
        try {
            byArray = Files.readAllBytes(file.toPath());
        }
        catch (Exception exception) {
            evaluationState.errorMgr.addError(new AsmError("Error while loading file '" + string + "': " + exception.getMessage(), sourceRange));
            return null;
        }
        if (byArray.length < 2) {
            evaluationState.errorMgr.addError(new AsmError("'" + string + "' is an invalid prg-file. Less than two bytes.", sourceRange));
            return null;
        }
        int n2 = (byArray[0] & 0xFF) + ((byArray[1] & 0xFF) << 8);
        byte[] byArray2 = Arrays.copyOfRange(byArray, 2, byArray.length);
        MemoryBlock memoryBlock = new MemoryBlock(n2, file.getName(), false, n);
        memoryBlock.addBytes(byArray2, sourceRange);
        return memoryBlock;
    }

    public MemoryBlock(int n, String string, boolean bl, int n2) {
        this.startAdress = n;
        this.name = string == null ? "unnamed" : string;
        this.virtual = bl;
        this.memory = bl ? null : new ByteArray(4096);
        this.maxMemoryAdress = n2;
    }

    public String getName() {
        return this.name;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void addByte(byte by, SourceRange sourceRange) {
        if (this.maxMemoryAdress >= 0 && this.startAdress + this.size > this.maxMemoryAdress) {
            throw new AsmErrorException("ERROR! Memory overflow. Memory exceeds the " + this.maxMemoryAdress + " bytes limit!", sourceRange);
        }
        if (!this.virtual) {
            this.memory.addByte(by);
        }
        ++this.size;
    }

    public void addBytes(byte[] byArray, SourceRange sourceRange) {
        for (int i = 0; i < byArray.length; ++i) {
            this.addByte(byArray[i], sourceRange);
        }
    }

    public int getStartAdress() {
        return this.startAdress;
    }

    public String getHexStartAddress() {
        return String.format("$%04x", this.startAdress);
    }

    public String getHexEndAddress() {
        return String.format("$%04x", this.startAdress + this.size - 1);
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getMemory() {
        return this.memory.getBytes();
    }

    public boolean contentEquals(MemoryBlock memoryBlock) {
        boolean bl;
        boolean bl2 = bl = this.name.equals(memoryBlock.name) && this.startAdress == memoryBlock.startAdress && this.size == memoryBlock.size && this.virtual == memoryBlock.virtual;
        if (!bl) {
            return false;
        }
        byte[] byArray = this.getMemory();
        byte[] byArray2 = memoryBlock.getMemory();
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public kickass.plugins.interf.IMemoryBlock getPluginMemoryBlock() {
        if (this.pluginMemoryBlock == null) {
            this.pluginMemoryBlock = new PluginMemoryBlock();
        }
        return this.pluginMemoryBlock;
    }

    private class PluginMemoryBlock
    implements kickass.plugins.interf.IMemoryBlock,
    IMemoryBlock {
        private PluginMemoryBlock() {
        }

        @Override
        public int getStartAddress() {
            return MemoryBlock.this.getStartAdress();
        }

        @Override
        public byte[] getBytes() {
            return MemoryBlock.this.getMemory();
        }

        @Override
        public String getName() {
            return MemoryBlock.this.getName();
        }
    }
}

